#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use File::Basename;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use locale;
use Encode;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');
  
$title = $ADD_CATEGORY_TITLE_PAGE;
  
my $name = param("name");
my $action = param("action");
  
if($action ne '')
{
	$name = htmlspecialchars(trim($name));
	if($name eq '') { error($ERR_EMPTY_NAME); }

	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CAT." WHERE name LIKE '$name'");
	  
	if(scalar(@_=$query->fetchrow_array) > 0)
	{
		error($ERR_CATEGORY_ALREADY_EXISTS);
	}
	  
	$query->finish();
	  	  
	$name = invert_comas($name);

	my $query = $dbh->prepare("INSERT INTO ".Constants::DB_CAT." (`id_cat`,`name`) VALUES (0,'$name')");
	$query->execute() or die("Error executing SQL query!");
	  
	$query->finish();
	$dbh->disconnect(); 

	redirect($MSG_CATEGORY_ADDED,"category.pl",2);	
}
else
{
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	
print <<HTML1
<a href="category.pl">$STR_RETURN_BACK</a><br><br>
<div class="tableform" style="width: 330px">
<form action="add_category.pl" method=post>
<input type="hidden" name="action" value="post">
<table border="0"><tr>
<td width="130">$TH_TABLE_NAME:</td>
<td width="200"><input size="20" type="text" name="name" value="$name"></td>
</tr>
<tr>
<td><input type="submit" class="inputsubmit" value="$BUTTON_ADD"></td>
</tr></table>
</form>
</div>
HTML1
;
	 
	$dbh->disconnect(); 
	 
	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
}