#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use Digest::MD5 qw(md5 md5_hex md5_base64); 
use locale;
use POSIX;
use File::Basename;
use MIME::Base64;

use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;

require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "_delete.pl"!');  
  
$title = $ADDSEND_TITLE_PAGE;
  
my $name;
my $message;
my $prior;
my $id_cat;
my $action = param("action");

if($action ne ''){
	$name = trim(param("name"));
	$message = trim(param("msg"));
	$prior = param("prior");
	$id_cat = param("id_cat");
  
	if($name eq '') { error($ERR_EMPTY_SUBJECT); }
	if($message eq '') { error($ERR_EMPTY_CONTENT); }
  
	if($row_setting->{'ContentType'} == 2) { $message =~ s/\\r\\n|<br>\\r\\n/<br>/g; }

	$name = invert_comas($name);
	$message = invert_comas($message);
	 
	$pos = 0;

	my $query = $dbh->prepare("SELECT MAX(pos) FROM ".Constants::DB_SEND."");
	$query->execute() or die("Error executing SQL query!");
	my $total = $query->fetchrow_arrayref()->[0];
  
	if($total) { $pos = $total + 1; }
	else { $pos = 1; }
	  
	my @File_Name =  param();
	  
	my $query = $dbh->prepare("INSERT INTO ".Constants::DB_SEND." (`id_send`,`name`,`message`,`prior`,`pos`,`id_cat`,`active`) VALUES (NULL, '".$name."', '".$message."', '".$prior."', ".$pos.", ".$id_cat.", 'yes')");
 
	if($query->execute())
	{
		my $id = $query->{'mysql_insertid'};	 
		my $mimetype;	
		my $file;		
		my $data;
		
		for($i=0; $i<scalar(@File_Name); $i++)
		{
			if($File_Name[$i] =~ /mail_file/){ 
				$file = param($File_Name[$i]);
				$data = '';
				
				while (<$file>) {
					$data .= $_;
				}
				
				if($id ne '' and $file ne ''){
					$mimetype = uploadInfo($file)->{'Content-Type'};	

					if(length($data)>16777000) { 
						error($ERR_LIMIT_IS_EXCEEDED);	
					}
				
					$data = encode_base64($data);
		
					$dbh->do("INSERT INTO ".Constants::DB_ATTACH." (`id_attachment`,`name`,`attach`,`mimetype`,`id_send`) VALUES (0,'".$file."','".$data."','".$mimetype."','".$id."')");
				}				
			}			
		}
	  
		$query->finish();
		$dbh->disconnect();
	
		redirect($MSG_MAILLIST_ADDED,"index.pl",2);
	}
	else { error("Error executing SQL query!"); }
}
  
if($action eq '')
{
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	 
print <<HTML1;
<script type=text/javascript src="$path/jscripts/tiny_mce/tiny_mce.js"></script>
<script type="text/javascript">

function add_mail_file(bl_name, num)
{
	var addF = document.forms['addF'];
	prev_num = parseInt(num)-1;
	bl_name += "_";
	par_div = document.getElementById(bl_name+prev_num).parentNode;
	adding_block = document.createElement("div");
	adding_block.id = bl_name+num;

	if(bl_name == "loadfile_") adding_block.innerHTML = "<div id=loadfile_"+(parseInt(num))+"><table border=0 cellpadding=0 cellspacing=0 id=addf_table_"+(parseInt(num))+"><tr><td><div id=\\"Div_File_"+(parseInt(num))+"\\"><input type=\\"file\\" onChange=\\"add_mail_file('loadfile', '"+((parseInt(num))+1)+"'); return false;\\" size=\\"50\\" class=\\"input\\" id=\\"file_"+(parseInt(num))+"\\" name=\\"mail_file_"+(parseInt(num))+"\\"></div></td><td valign=middle>&nbsp;&nbsp;<a class=l_text onclick=\\"del_pole(this);\\" href=\\"#\\">$STR_REMOVE</a></td></tr></table></div>";

	par_div.appendChild(adding_block);
}

function del_pole(btn)
{
	if(document.getElementById)
	{
		while(btn.tagName != 'TR') btn = btn.parentNode;
		btn.parentNode.removeChild(btn);
	}
}

tinyMCE.init({

	forced_root_block : false,
	force_br_newlines : true,
	force_p_newlines : false,
	relative_urls : false,
	remove_script_host : true,
	convert_urls : false,

	// General options
	mode : "textareas",
	theme : "advanced",
	language : "ru",
	plugins : "autolink,lists,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template,wordcount,advlist,autosave,visualblocks",

	// Theme options
	theme_advanced_buttons1 : "save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
	theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
	theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|,fullscreen",
	theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak,restoredraft,visualblocks",
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_statusbar_location : "bottom",
	theme_advanced_resizing : true,

	// Example content CSS (should be your site CSS)
	content_css : "css/content.css",

	// Drop lists for link/image/media/template dialogs
	template_external_list_url : "lists/template_list.js",
	external_link_list_url : "lists/link_list.js",
	external_image_list_url : "lists/image_list.js",
	media_external_list_url : "lists/media_list.js",

	// Style formats
	style_formats : [
		{title : 'Bold text', inline : 'b'},
		{title : 'Red text', inline : 'span', styles : {color : '#ff0000'}},
		{title : 'Red header', block : 'h1', styles : {color : '#ff0000'}},
		{title : 'Example 1', inline : 'span', classes : 'example1'},
		{title : 'Example 2', inline : 'span', classes : 'example2'},
		{title : 'Table styles'},
		{title : 'Table row 1', selector : 'tr', classes : 'tablerow1'}
	],

	// Replace values for the template plugin
	template_replace_values : {
		username : "Some User",
		staffid : "991234"
	}
});

</script>
<div class="tableform">
<form enctype='multipart/form-data' action="addsend.pl" method=post>
<table class="content" width="640"><tr>
<td valign="top">
<tr><td width="97">$STR_SUBJECT:</td><td colspan="2"><input size="50" class="input" type="text" name="name" value=""></td></tr>
<tr><td width="97">$STR_CONTENT:</td>
<td colspan="2"><textarea id="msg" name="msg" class="input2" rows="15" cols="60"></textarea></td>
<tr><td colspan="2">$STR_NOTE</td></tr>
</tr>
<tr>
<td width="97">$STR_ATTACH_FILE:</td>
<td width="97" colspan="2">
<div id=loadfile_0>
<table border="0" cellpadding="0" cellspacing="0"><tr>
<td><input type="file" size="50" name="mail_file_0" class="input" id="file_0_input" onChange="add_mail_file('loadfile', '1'); return false;"></td>
</tr></table>
</div></td>
</tr>
<tr>
<td width="97">$STR_CATEGORY:</td>
<td colspan="2">
HTML1
;
	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CAT." ORDER BY name");
	$query->execute() or die("Error executing SQL query!");
  
	print '<select type="text" name="id_cat">';
	print '<option value="0" '.(($id_cat == 0 or $id_cat != '')?' selected="selected"':'').'>'.$STR_SEND_ALL.'</option>';
  
	while(my $row = $query->fetchrow_hashref())
	{
		print '<option value="'.$row->{'id_cat'}.'"'.(($id_cat == $row->{'id_cat'})?' selected="selected"':'').'>'.$row->{'name'}.'</option>';
	}
	
	print '</select>';
  
	$query->finish();
	
	my $prior_choise;
	$prior_choise .= '<table class="content" border="0"><tr>';
	$prior_choise .= '<td><input name="prior" type="radio" value="3" '.((param("prior") == 3 or param("prior") eq '')?'checked="checked"':'').'>'.$STR_NORMAL.'</td>';
	$prior_choise .= '<td><input type="radio" name="prior" value="2" '.((param("prior") == 2)?'checked="checked"':'').'>'.$STR_LOW.'</td>';
	$prior_choise .= '<td><input type="radio" name="prior" value="1" '.((param("prior") == 1)?'checked="checked"':'').'>'.$STR_HIGH.'</td>';
	$prior_choise .= '</table>';
	
print <<HTML2
</td>
</tr>
<tr>
<td width="97">$STR_PRIOR:</td>
<td>$prior_choise</td>
</tr>
<tr><td></td><td colspan="2">&nbsp;</td></tr>
<tr><td></td><td><input type="submit" class="inputsubmit" value="$BUTTON_ADD">
<input type="hidden" name="action" value="post">
</td>
</tr></table>
</form>
</div>
HTML2
;
	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
}
  
$dbh->disconnect();