#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use Digest::MD5 qw(md5 md5_hex md5_base64); 
use locale;
use File::Basename;
use Encode;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');

$title = $SUBRS_CATEGORY_TITLE_PAGE;
  
require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
  
print <<HTML1
<table class="cattab content" cellSpacing="1" cellPadding="5" border="0" width="100%"><tr>
<th class="catmenu toptab" align="middle">$TH_TABLE_NAME</td>
<th class="catmenu toptab" align="middle">$TH_TABLE_NUMBER_OF_SUBRS</td>
<th class="catmenu toptab" align="middle">$TH_TABLE_EDIT</td>
<th class="catmenu toptab" align="middle">$TH_TABLE_ACTION</td>
</tr>
HTML1
;
  
my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CAT." ORDER BY name");
$query->execute() or die("Error executing SQL query!");
  
while(my $row = $query->fetchrow_hashref())
{
	my $query = $dbh->prepare("SELECT COUNT(*) FROM ".Constants::DB_SUB." WHERE id_cat=".$row->{'id_cat'}."");
	$query->execute() or die("Error executing SQL query!");
	my $count = $query->fetchrow_arrayref()->[0];
  
	$query->finish();
		
	print '<tr class=trcat>';
	print '<td align=middle>'.$row->{'name'}.'</td>';
	print '<td align=middle>'.$count.'</td>';
	print '<td align=middle><a href="edit_category.pl?id_cat='.$row->{'id_cat'}.'">'.$STR_EDIT.'</a></td>';
		
	if($count>0){
		print '<td align=middle><a href=del_category.pl?id_cat='.$row->{'id_cat'}.' onclick="return confirm(\''.$STR_CATEGORY_HAS.' '.$count.'\\n'.$QUESTION_CONFIRM_REMOVE.'\');">'.$STR_REMOVE.'</a></td>';
	}
	else{		
		print '<td align=middle><a href=del_category.pl?id_cat='.$row->{'id_cat'}.'>'.$STR_REMOVE.'</a></p></td>';
	}
}
	
print <<HTML2
</tr></table><br>
<form action="add_category.pl" method=post>
<input type="submit" class="button" value="$BUTTON_ADD">
</form>
HTML2
;
	
$query->finish();
  
require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
  
$dbh->disconnect();