#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use locale;
use Digest::MD5  qw(md5 md5_hex md5_base64);
use Encode;
use File::Basename;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';

use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');

$query->finish();
  
my $error = "";
my $action = param("action");
  
if($action ne '')
{
	my $password = trim(param("password"));
	my $password_again = trim(param("password_again"));
	my $current_password = trim(param("current_password"));

	if($current_password eq '')
	{
		$action = "";
		$error = $error."<li>".$ERR_EMPTY_CURRENT_PASSWORD."</li>"; 
	}

	if($password eq '')
	{
		$action = "";
		$error = $error."<li>".$ERR_EMPTY_PASSWORD."</li>";
	} 

	if($password_again eq '')
	{
		$action = "";
		$error = $error."<li>".$ERR_EMPTY_PASSWORD_AGAIN."</li>";
	}

	if($password ne '' and $password_again ne '')
	{
		if($password ne $password_again)
		{
			$action = "";
			$error = $error."<li>".$ERR_PASSWORDS_DONT_MATCH."</li>";
		}
	}

	if($current_password ne '')
	{
		$query = $dbh->prepare("SELECT passw FROM ".Constants::DB_AUT."");
		$query->execute() or die("Error executing SQL query!");
		$row = $query->fetchrow_hashref();
		$passw = $row->{'passw'};
	  
		$query->finish();
  		$current_password = md5_hex($current_password);
  
		if($passw ne $current_password)
		{
			$action = "";
			$error = $error."<li>".$ERR_INCORECT_CURRENT_PASSWORD."</li>";
		}
	}

	if($error eq '')
	{
		$login_new = invert_comas($login_new);

		$password = md5_hex($password);
			  
		$query = $dbh->prepare("UPDATE ".Constants::DB_AUT." SET passw='$password'");
		$query->execute() or die("Error executing SQL query!");
		$query->finish();

		redirect($MSG_ADD_CHANGES,"index.pl",2);
	}
}
  
if($action eq  '')
{
	$title = $CHANGE_TITLE_PAGE; 
  
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	 
print <<HTML1
<h3>$STR_ENTER_NEW_PASSWORD</h3>
<div class="tableform" style="width: 330px">
<form action="change.pl" method="post">
<input type="hidden" name="action" value="post">
<table border="0">
<tr><td>$STR_CURRENT_PASSWORD:</td><td><input type="password" name="current_password" maxlength="40" size="25"></td></tr>
<tr><td>$STR_NEW_PASSWORD:</td><td><input type="password" name="password" maxlength="40" size="25"></td></tr>
<tr><td>$STR_REPEAT_PASSWORD:</td><td><input type="password" name="password_again" maxlength="40" size="25"></td></tr>
<tr><td></td><td><input class="inputsubmit" type="submit" value="$BUTTON_CHANGE"></td>
</tr></table>
</form>
</div>
HTML1
;
  
	if($error ne '')
	{
		print "<p>".$STR_ERRORLIST.": </p>";
		print "<ul><font color=#CC0000>";
		print $error;
		print "</font></ul>";
	}
  
	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
}

$dbh->disconnect(); 