#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use File::Basename;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use locale;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');

$title = $EDIT_CATEGORY_TITLE_PAGE; 
  
my $name = trim(param("name"));
my $id_cat = param("id_cat"); 
my $action = param("action");
  
if($action ne '')
{
	if($name eq '') { error($ERR_EMPTY_NAME); } 
	  
	$name = invert_comas(htmlspecialchars($name));
	$id_cat = invert_comas($id_cat);

	my $query = $dbh->prepare("UPDATE ".Constants::DB_CAT." SET name='$name' WHERE id_cat=$id_cat");
	$query->execute() or die("Error executing SQL query!");
	  
	$query->finish();
	  
	$dbh->disconnect(); 

	redirect($MSG_ADD_CHANGES,"category.pl",2); 	  
}
else
{
	my %GET;
	my @pairs = split(/&/, $ENV{"QUERY_STRING"});

	foreach (@pairs)
	{
		my ($name, $value) = split(/=/, $_);
		$GET{$name} = $value;
		$value = uri_unescape($value);
	}
  
	$id_cat = int($GET{'id_cat'});
	
	my $query = $dbh->prepare("SELECT name FROM ".Constants::DB_CAT." WHERE id_cat=$id_cat");
	$query->execute() or die("Error executing SQL query!");

	my $row = $query->fetchrow_hashref();
	my $name = $row->{'name'};
	 
	$query->finish();
	
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	 
print <<HTML1
<a href="category.php">$STR_RETURN_BACK</a><br><br>
<div class="tableform" style="width: 330px">
  <form action="edit_category.pl" method=post>
  	<input type="hidden" name="id_cat" value="$id_cat">
	<input type="hidden" name="action" value="post">
	 <table border="0">
		<tr>
		  <td width="130">$TH_TABLE_NAME:</td>
		  <td width="250"><input size="20" type="text" name="name" value="$name"></td>
		</tr>
		<tr>
		  <td><input type="submit" class="inputsubmit" value="$BUTTON_EDIT"></td>
		  <td>&nbsp;</td>
		</tr>
	 </table>
  </form>
</div>
HTML1
; 
	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
	
	$dbh->disconnect();
}