#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use Digest::MD5 qw(md5 md5_hex md5_base64); 
use locale;
use POSIX;
use File::Basename;
use Encode;
use MIME::Base64;

use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');

$title = $EDITSEND_TITLE_PAGE;
  
my $name = trim(param("name"));
my $message = trim(param("msg"));
my $prior = param("prior");
my $id_cat = param("id_cat");
my $id_send = param("id_send");
my $action = param("action"); 
  
if($action ne '')
{
	if($name eq '') { error($ERR_EMPTY_SUBJECT); }
	if($message eq '') { error($ERR_EMPTY_CONTENT); }
	 
	if($settings->{'content_type'} == 2) { $message =~ s/\\r\\n|<br>\\r\\n/<br>/g; }

	$name = invert_comas($name);
	$message = invert_comas($message);
	$id_cat = invert_comas($id_cat);
	$id_send = invert_comas($id_send);
	$prior = invert_comas($prior);
				
	my $query = $dbh->prepare("UPDATE ".Constants::DB_SEND." SET name='$name', message='$message', prior='$prior', id_cat='$id_cat' WHERE id_send='$id_send'");
	$query->execute() or die("Error executing SQL query!");
	  
	$query->finish();
	
	my $query = $dbh->prepare("DELETE FROM ".Constants::DB_ATTACH." WHERE id_send=$id_send");
	$query->execute() or die("Error executing SQL query!"); 
	
	$query->finish();	  
	 
	my $del=0;
	my @File_Name =  param(); 	

	my $mimetype;	
	my $file;		
	my $data;
	
	for($i=0; $i<scalar(@File_Name); $i++){
		if($File_Name[$i] =~ /mail_file/){ 
			$file = param($File_Name[$i]);
			$data = '';
				
			while (<$file>) {
				$data .= $_;
			}
				
			if($file ne ''){
				$mimetype = uploadInfo($file)->{'Content-Type'};	

				if(length($data)>16777000) { 
					error($ERR_LIMIT_IS_EXCEEDED);	
				}
				
				$data = encode_base64($data);
				$dbh->do("INSERT INTO ".Constants::DB_ATTACH." (id_attachment,name,attach,mimetype,id_send) VALUES (0,'".$file."','".$data."','".$mimetype."','".$id_send."')");
			}				
		}			
	}	

	$dbh->disconnect();
	
	redirect($MSG_ADD_CHANGES,"index.pl",2); 
}
else
{
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');

	my %GET;
	my @pairs = split(/&/, $ENV{"QUERY_STRING"});

	foreach (@pairs){
		my ($name, $value) = split(/=/, $_);
		$GET{$name} = $value;
		$value = uri_unescape($value);
	}

	my $id_send = int($GET{'id_send'});
	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_SEND." WHERE id_send=$id_send");
	  
	$query->execute() or die("Error executing SQL query!");
	  
	my $row = $query->fetchrow_hashref();
	my $name = $row->{'name'};
	my $prior = $row->{'prior'};
	my $message = $row->{'message'};
	

	$query->finish();

print <<HTML1;	 
<script type=text/javascript src="$path/jscripts/tiny_mce/tiny_mce.js"></script>
<script type="text/javascript">

function add_mail_file(bl_name, num)
{
	var addF = document.forms['addF'];
	prev_num = parseInt(num)-1;
	bl_name += "_";
	par_div = document.getElementById(bl_name+prev_num).parentNode;
	adding_block = document.createElement("div");
	adding_block.id = bl_name+num;

	if(bl_name == "loadfile_") adding_block.innerHTML = "<div id=loadfile_"+(parseInt(num))+"><table border=0 cellpadding=0 cellspacing=0 id=addf_table_"+(parseInt(num))+"><tr><td><div id=\\"Div_File_"+(parseInt(num))+"\\"><input type=\\"file\\" onChange=\\"add_mail_file('loadfile', '"+((parseInt(num))+1)+"'); return false;\\" size=\\"50\\" class=\\"input\\" id=\\"file_"+(parseInt(num))+"\\" name=\\"mail_file_"+(parseInt(num))+"\\"></div></td><td valign=middle>&nbsp;&nbsp;<a class=l_text onclick=\\"del_pole(this);\\" href=\\"#\\">$STR_REMOVE</a></td></tr></table></div>";

	par_div.appendChild(adding_block);
}

function del_pole(btn)
{
	if(document.getElementById)
	{
		while(btn.tagName != 'TR') btn = btn.parentNode;
		btn.parentNode.removeChild(btn);
	}
}

tinyMCE.init({

	forced_root_block : false,
	force_br_newlines : true,
	force_p_newlines : false,
	relative_urls : false,
	remove_script_host : true,
	convert_urls : false,

	// General options
	mode : "textareas",
	theme : "advanced",
	language : "ru",
	plugins : "autolink,lists,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template,wordcount,advlist,autosave,visualblocks",

	// Theme options
	theme_advanced_buttons1 : "save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
	theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
	theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|,fullscreen",
	theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak,restoredraft,visualblocks",
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_statusbar_location : "bottom",
	theme_advanced_resizing : true,

	// Example content CSS (should be your site CSS)
	content_css : "css/content.css",

	// Drop lists for link/image/media/template dialogs
	template_external_list_url : "lists/template_list.js",
	external_link_list_url : "lists/link_list.js",
	external_image_list_url : "lists/image_list.js",
	media_external_list_url : "lists/media_list.js",

	// Style formats
	style_formats : [
		{title : 'Bold text', inline : 'b'},
		{title : 'Red text', inline : 'span', styles : {color : '#ff0000'}},
		{title : 'Red header', block : 'h1', styles : {color : '#ff0000'}},
		{title : 'Example 1', inline : 'span', classes : 'example1'},
		{title : 'Example 2', inline : 'span', classes : 'example2'},
		{title : 'Table styles'},
		{title : 'Table row 1', selector : 'tr', classes : 'tablerow1'}
	],

	// Replace values for the template plugin
	template_replace_values : {
		username : "Some User",
		staffid : "991234"
	}
});

</script>
<div class="tableform">
<form name="form" enctype="multipart/form-data" action="editsend.pl" method=post>
<input type="hidden" name="id_send" value="$id_send">
<table class="content" width="640"><tr>
<td valign="top">
<tr><td width="97">$STR_SUBJECT:</td><td colspan="2"><input size="50" class="input" type="text" name="name" value="$name"></td></tr>
<tr><td width="97">$STR_CONTENT:</td>
<td colspan="2"><textarea id="msg" name="msg" class="input2" rows="15" cols="60">$message</textarea></td>
<tr><td colspan="2">$STR_NOTE</td>
</tr>
HTML1
;

	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_ATTACH." WHERE id_send=$id_send ORDER BY name");
	$query->execute() or die("Error executing SQL query!"); 
	 
	my $attach_file = "";

	while(my $row=$query->fetchrow_hashref())
	{
		$attach_file .= "".$row->{'name'}."&nbsp;";
	}
	  
	$query->finish();
	  
	if($attach_file ne '')
	{ 
		print "<tr><td width=97>".$STR_ATTACH_FILE.": </td><td colspan=2><p>$attach_file <a href=\"del_attach.pl?id_send=".$id_send."\" title=\"".$STR_REMOVE."\">".$STR_REMOVE."</a></p></td></tr>\n"; 
	}

print <<HTML2;
<tr>
<td width="97">$STR_ATTACH_FILE:</td>
<td width="97" colspan="2">
<div id=loadfile_0>
<table border="0" cellpadding="0" cellspacing="0"><tr>
<td><input type="file" size="50" name="mail_file_0" class="input" id="file_0_input" onChange="add_mail_file('loadfile', '1'); return false;"></td>
</tr></table>
</div></td>
</tr>
<tr>
<td width="97">$STR_CATEGORY:</td>
<td colspan="2">
HTML2
;
	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CAT." ORDER BY name");
	$query->execute() or die("Error executing SQL query!");
   
	print '<select type="text" name="id_cat">';
	print '<option value="0"'.(($id_cat == 0 or $id_cat == '')?' selected="selected"':'').'>'.$STR_SEND_ALL.'</option>';
   
	while(my $row = $query->fetchrow_hashref())
	{
		print '<option value="'.$row->{'id_cat'}.'"'.(($id_cat == 0 or $id_cat == '')?' selected="selected"':'').'>'.$row->{'name'}.'</option>';
	}
   
	print '</select>';
  
	$query->finish();

	my $prior_choise;
	$prior_choise .= '<table class="content" border="0"><tr>';
	$prior_choise .= '<td><input name="prior" type="radio" value="3" '.(($prior == 3 or $prior eq '')?'checked="checked"':'').'>'.$STR_NORMAL.'</td>';
	$prior_choise .= '<td><input type="radio" name="prior" value="2" '.(($prior == 2)?'checked="checked"':'').'>'.$STR_LOW.'</td>';
	$prior_choise .= '<td><input type="radio" name="prior" value="1" '.(($prior == 1)?'checked="checked"':'').'>'.$STR_HIGH.'</td>';
	$prior_choise .= '</table>';
	
print <<HTML2
</td>
</tr>
<tr>
<td width="97">$STR_PRIOR:</td>
<td>$prior_choise</td>
</tr>
<tr><td></td><td colspan="2">&nbsp;</td></tr>
<tr><td></td><td><input type="submit" class="inputsubmit" value="$BUTTON_EDIT">
<input type="hidden" name="action" value="post">
</td>
</tr></table>
</form>
</div>
HTML2
;
	
	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
}
  
$dbh->disconnect();