#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use File::Basename;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use locale;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');
  
my $name = trim(param("name"));
my $email= lc(trim(param("email")));
my $id_user = param("id_user");
my @id_cat = param("id_cat[]");
  
$title = $EDITUSER_TITLE_PAGE;
  
my $action = param("action");
  
if($action ne '')
{
	if($name eq '') { error($ERR_EMPTY_NAME); }
	if($email eq '') { error($ERR_EMPTY_EMAIL); }
	 
	if(check_email($email) ne true)
	{
		error($ERR_WRONG_EMAIL);
	}
	 
	$name = htmlspecialchars($name);
	$name = invert_comas($name); 
	$id_user = invert_comas($id_user);
	
	my $update = $dbh->prepare("UPDATE ".Constants::DB_USERS." SET name='".$name."', email='".$email."' WHERE id_user='$id_user'");
	 
	$update->execute() or die("Error executing SQL query!");
	$update->finish();	
	
	my $delete = $dbh->prepare("DELETE FROM ".Constants::DB_SUB." WHERE id_user='$id_user'");
	$delete->execute() or die("Error executing SQL query!");
	$delete->finish();
	
	foreach (@id_cat)
	{ 
		if($_ =~ /^[\d]+$/){
			$dbh->do("INSERT INTO ".Constants::DB_SUB." (`id_sub`,`id_user`,`id_cat`) VALUES (0,'$id_user','$_')");
		}
	}
	
	redirect($MSG_ADD_CHANGES,"subscribers.pl",2); 
}
else
{
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	 
	my %GET;
	my @pairs = split(/&/, $ENV{"QUERY_STRING"});

	foreach (@pairs)
	{
		my ($name, $value) = split(/=/, $_);
		$GET{$name} = $value;
		$value = uri_unescape($value);
	} 
	 
	$id_user = int($GET{'id_user'});
	 
	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_USERS." WHERE id_user=$id_user");
	$query->execute() or die("Error executing SQL query!");
	 
	my $row = $query->fetchrow_hashref();
	my $name = $row->{'name'};
	my $email = $row->{'email'};
	my $id_user = $row->{'id_user'};
	my $id_cat = $row->{'id_cat'};
	 
	$query->finish();
	
print <<HTML1
<a href="subscribers.pl">« $STR_RETURN_BACK</a><br>
<form enctype="multipart/form-data" action="edituser.pl" method="post">
<input type="hidden" name="id_user" value="$id_user">
<div class="tableform" style="width: 380px">
<table border="0"><tr>
<td width="130">$TH_TABLE_NAME</td>
<td width="250"><input size="30" type="text" name="name" value="$name"></td>
</tr>
<tr><td width="130">E-mail</td>
<td width="250"><input size="30" type="text" name="email" value="$email"></td>
</tr>
<tr><td width="130">$STR_CATEGORY</td>
<td width="250">
HTML1
;
	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CAT." ORDER BY name");
	$query->execute() or die("Error executing SQL query!");

	while(my $row = $query->fetchrow_hashref())
	{
		my $category = $dbh->prepare("SELECT * FROM ".Constants::DB_SUB." WHERE id_cat=".$row->{'id_cat'}." AND id_user=".$id_user."");
		$category->execute() or die("Error executing SQL query!");
			
		my $checked = ($category->rows>0?' checked':'');
		print '<p><input type="checkbox" value="'.$row->{'id_cat'}.'" name="id_cat[]"'.$checked.'>'.$row->{'name'}.'</p>';
		
		$category->finish();
	}	
	  
	$query->finish();
	  
print <<HTML2
</td>
</tr>
<tr><td><input type="submit" name="action" class="inputsubmit" value="$BUTTON_EDIT"></td><td></td>
</tr></table>
</div>
</form>
HTML2
;

	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
	  
	$dbh->disconnect();  
}
