#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use CGI qw(:standard);
use locale;
use Digest::MD5  qw(md5 md5_hex md5_base64);
use Encode;
use Archive::Zip;
use File::Copy;
	 
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');

$ext = trim(param('ext'));
	 
my $query = $dbh->prepare("SELECT name,email FROM ".Constants::DB_USERS." WHERE status = 'active'"); 
$query->execute() or die("Error executing SQL query!");

$name_f = "export.".$ext."";
	
my $data;
	
while(my $row = $query->fetchrow_hashref())
{
	if(param('pos_el') == 1){
		$data .= "".$row->{'email'}." ".$row->{'name'}."\n";
	}
	else{
		$data .= "".$row->{'name'}." ".$row->{'email'}."\n";
	}
}
		
$query->finish(); 

if(param('zip') == 1){
	print "Content-type: application/octet-stream;\n";
	print "Content-Disposition: attachment; filename=".$name_f."\n";
	print "Content-Length: ".length($data)."\n\n";
	print $data;
	exit;
}
else{
	my $zipfile = "export.zip";
	my $zip = Archive::Zip->new();
	
	my $member = $zip->addString($data, $name_f);
	$member->desiredCompressionLevel( 7 );
	$zip->writeToFileNamed($zipfile);
	
	if(-e $zipfile){
	
	my $size = -s $zipfile;
		print "Content-type: application/zip;\n";
		print "Content-Disposition: attachment; filename=".$zipfile."\n";
		print "Content-Length: ".$size."\n\n";
		
		open (ZIP,"< $zipfile");
        binmode(ZIP);
        binmode(STDOUT);		
		
        while(defined(my $fileout = <ZIP>)) {
            print "$fileout";
        }
		
        close(ZIP);
		
		unlink($zipfile);
		exit;
	}
	else{
		print "Content-Type: text/html\n\n";
		print "ERROR: ".$ERR_CANNOT_CREATE_ARCHIVE." ".$zipfile."\n";
	}	
}