#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use File::Basename;
use locale;
use POSIX;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');

$title = $IMPORT_TITLE_PAGE;

my $action = ""; 
$action = param('action');
  
if($action eq '')
{
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	 
print <<HTML1
<div class="tableform">
<form enctype='multipart/form-data' action="import.pl" method="post">
<table cellpadding="5">
<tr>
<td width="30%">$STR_DATABASE_FILE :</td>
<td><input class="input" type="file" name="file" size="20"></td>
</tr>
<tr>
<td width="30%">$STR_CATEGORY:</td>
<td>
HTML1
;
	my $query = $dbh->prepare("SELECT *,cat.id_cat as id FROM ".Constants::DB_CAT." cat LEFT JOIN ".Constants::DB_SUB." subs ON cat.id_cat=subs.id_cat GROUP by id ORDER BY name");
	$query->execute() or die("Error executing SQL query!");
	
	while(my $row = $query->fetchrow_hashref()){
		print '<p><input type="checkbox" value="'.$row->{'id'}.'" name="id_cat[]">'.$row->{'name'}.'</p>';
	}

	$query->finish();
	
print <<HTML2
</td>
</tr>
<tr>
<td>
<input class="inputsubmit" type="submit" value="$BUTTON_ADD">
<input type="hidden" name="action" value="post">
</td>
</tr>
</table>
</form>
</div>
HTML2
;
	$dbh->disconnect(); 
	
	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
}
else{
	my $File_Name = param('file');
	my @id_cat = param('id_cat[]');
	  
	if($File_Name eq '') { error($ERR_EMPTY_FILEPATH); }
	my $data;
	my $buffer = '';
	 
	binmode($File_Name);	
	while(read($File_Name, $data, 1024)) { $buffer.=$data; }
	 
	close($File_Name);
	
	$buffer = invert_comas($buffer);
	 
	my @tok = split("\n", $buffer);
	my $count=0;
	
	foreach $v (@tok) {
		my @out = ($v =~ m/([a-zA-Z0-9._\%+-]+\@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4})/);
		my $email = lc(trim($out[0]));
		my $name = $v;
		$name=~ s/$email//g;
		$name = trim($name);

		if(check_email($email) eq true){		
			$query = $dbh->prepare("SELECT * FROM ".Constants::DB_USERS." WHERE email LIKE '$email'");
			$query->execute() or die("Error executing SQL query!");
  
			if(scalar(@_=$query->fetchrow_array) > 0) { }
			else{		
				$count++;
				my $time_add = strftime("%Y-%m-%d %H:%M:%S", localtime);
				my $token = getRandomCod();				
				
				$insert = $dbh->prepare("INSERT INTO ".Constants::DB_USERS." (`id_user`,`name`,`email`,`ip`,`token`,`time`,`status`,`time_send`) VALUES (0,'$name','$email','','$token','$time_add','active','0000-00-00 00:00:00')");
				$insert->execute() or die("Error executing SQL query!");
				
				my $id = $insert->{'mysql_insertid'};
				
				foreach (@id_cat){ 
					if($_ =~ /^[\d]+$/) { 
						$dbh->do("INSERT INTO ".Constants::DB_SUB." (`id_sub`,`id_user`,`id_cat`) VALUES (0, ".$id.", ".$_.")");
					}				
				}
				
				$insert->finish();
			}			
		}
	}
	 
	$dbh->disconnect(); 

	redirect($MSG_DATA_ADDED,"import.pl",2); 
}