#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use File::Basename;
use locale;
use Digest::MD5  qw(md5 md5_hex md5_base64);
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');
  
my %GET;
my @pairs = split(/&/, $ENV{"QUERY_STRING"});

foreach (@pairs)
{
	my ($name, $value) = split(/=/, $_);
	$GET{$name} = $value;
	$value = uri_unescape($value);
}

my $action = param("action");
my @activate = param('activate[]');

if($action eq ''){
	$page = int($GET{'page'});
	if($page == 0) { $page = 1; }
	if($row_setting->{'number_pos'} == 0) { $row_setting->{'number_pos'} = 10; }
	$begin = ($page - 1)*$row_setting->{'number_pos'};
  
	$title = $INDEX_PAGE_TITLE;
  
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
  
	my $query = $dbh->prepare("SELECT *,s.name AS name,c.name AS catname FROM ".Constants::DB_SEND." s LEFT JOIN ".Constants::DB_CAT." c ON s.id_cat=c.id_cat ORDER BY pos LIMIT $begin, $row_setting->{'number_pos'}");
	$query->execute() or die("Error executing SQL query!");
  
print <<TABLE1 
<script type="text/javascript">

function sendout(str)
{
	id_send = str;
	process();
}

var xmlHttp = createXmlHttpRequestObject();

function createXmlHttpRequestObject()
{
	var xmlHttp;

	try
	{
		xmlHttp = new XMLHttpRequest();
	}
	catch (trymicrosoft)
	{
		try
		{
			xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (othermicrosoft)
		{
			try
			{
				xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (failed)
			{
				xmlHttp = false;
			}
		}
	}

	if (!xmlHttp) alert("$ERR_INTERFACE_INITIALIZATION");
	else return xmlHttp;
}

function process()
{
	document.getElementById("idsend_" + id_send).innerHTML = '<img src=/images/loader.gif>';
	document.getElementById("sendout_" + id_send).style.display = 'none';

	if(xmlHttp.readyState == 4 || xmlHttp.readyState == 0)
	{
		if(id_send != '')
		{
			var url = "send.pl?id_send=" + escape(id_send);
			xmlHttp.open("GET", url, true);
			xmlHttp.onreadystatechange = handleServerResponse;
			xmlHttp.send(null);
		}
	}
	else
	{
		setTimeout('process()', 1000);
	}
}

function handleServerResponse()
{
	document.getElementById("idsend_" + id_send).innerHTML = '<img src=/images/loader.gif>';
	document.getElementById("sendout_" + id_send).style.display = 'none';

	if(xmlHttp.readyState == 4)
	{
		if(xmlHttp.status == 200)
		{
			var msg = decodeURIComponent(xmlHttp.responseText);
		 
			document.getElementById("idsend_" + id_send).innerHTML = msg;
			setTimeout(function() { 
				document.getElementById("idsend_" + id_send).innerHTML = '';
				document.getElementById("sendout_" + id_send).style.display = '';
			}, 3000);
		}
		else
		{
			alert("$ERR_CONNECT_TO_SERVER: " + xmlHttp.statusText);
		}
	}
}

var DOM = (typeof(document.getElementById) != 'undefined');

function Check_action()
{
	if(document.forms[0].action.value==0) {window.alert('$ERR_NOT_CHOOSE_ACTION');}
}

function CheckAll_Activate(Element,Name)
{
	if(DOM)
	{
		thisCheckBoxes = Element.parentNode.parentNode.parentNode.getElementsByTagName('input');

		var m=0;

		for(var i = 1; i < thisCheckBoxes.length; i++)
		{
			if(thisCheckBoxes[i].name == Name)
			{
				thisCheckBoxes[i].checked = Element.checked;
				if(thisCheckBoxes[i].checked == true) m++;
				if(thisCheckBoxes[i].checked == false) m--;
			}
		}

		if(m > 0) { document.getElementById("Apply_").disabled = false; }
		else { document.getElementById("Apply_").disabled = true;  }
	}
}

function Count_checked()
{
	var All=document.forms[0];

	var m=0;

	for(var i = 0; i < All.elements.length; ++i)
	{
		if(All.elements[i].checked) { m++; }
	}

	if(m > 0) { document.getElementById("Apply_").disabled = false; }
	else { document.getElementById("Apply_").disabled = true;  }
}

</script>
<form action="index.pl" onSubmit="if(document.forms[0].action.value==0){window.alert('$ERR_NOT_CHOOSE_ACTION');return false;}if(document.forms[0].action.value==3){return confirm('$QUESTION_CONFIRM_REMOVE');}" method="post">
<table class="cattab content" cellspacing="1" cellpadding="3" border="0" width="100%">
<tr>
<th class="catmenu"><input type="checkbox" title="$STR_SELECT_ALL/$STR_DESELECT_ALL" onclick="CheckAll_Activate(this,'activate[]');"></td>
<th width="50%" class="catmenu toptab">$TH_NEWSLETTERS_LIST</td>
<th class="catmenu toptab">$TH_TABLE_CATEGORY</td>
<th class="catmenu toptab">$TH_TABLE_ACTIVITY</td>
<th class="catmenu toptab">$TH_TABLE_POS</td>
<th class="catmenu toptab">$TH_TABLE_EDIT</td>
<th class="catmenu toptab">$TH_TABLE_SEND</td>
</tr>
TABLE1
;
  
	while(my $row = $query->fetchrow_hashref())
	{
		my $id_send = $row->{'id_send'};
		my $name = $row->{'name'};
		my $message = $row->{'message'};
		my $prior = $row->{'prior'};
		my $id_cat = $row->{'id_cat'};
		my $catname = $row->{'catname'};
	 
		$name =~ s/^\s+|\s+$//g;
		$message =~ s/^\s+|\s+$//g;
		$message =~ s/\n/<br>/ig;
		$date =~ s/^\s+|\s+$//g; 
	 
		$pos = index(substr($message,600), " ");
	 
		if(int(length($message))>600) { $srttmpend = "..."; }
		else { $strtmpend = ""; }
	 
		$message =~ s/<(a)[^>]*>//ig;
		$message = substr($message, 0, 600+$pos).$srttmpend;
		$message =~ s/<br\s+(\/)?>/\n/ig;
		$message =~ s/<(\/)?[^>]*>//g;
		$message =~ s/\n/<br>/g;
	 	
		my $catname = (($id_cat == 0)? $STR_COMMON : $row->{'catname'});
		my $active = ($row->{'active'} eq 'yes' ? $STR_YES : $STR_NO);
	
		print '<tr class=trcat>';
		print '<td align="center" class="td2"><input type="checkbox" onclick="Count_checked();" title="$STR_SELECT/$STR_DESELECT" value="'.$id_send.'" name=activate[]></td>';
		print '<td><a title="'.$STR_EDIT_NEWLETTER.'" href="editsend.pl?id_send='.$id_send.'">'.$name.'</a><br><br>'.$message.'</td>';
		print '<td align="center">'.$catname.'</td>';
		print '<td align="center">'.$active.'</td>';
		print '<td align="center"><a href="up.pl?id_send='.$id_send.'" title="'.$STR_UP.'">';
		print '<img border="0" src="/images/up.gif" width="20" height="20"></a><br><br>';
		print '<a href="down.pl?id_send='.$id_send.'" title="'.$STR_DOWN.'"><img border="0" src="/images/down.gif" width="20" height="20"></a></td>';
		print '<td align="center"><a href="editsend.pl?id_send='.$id_send.'" title="'.$STR_EDIT_NEWLETTER.'"><img border="0" src="/images/edit.gif" width="24" height="24"></a></td>';
		print '<td align="center"><a id="sendout_'.$id_send.'" onClick="sendout('.$id_send.');" href="#" title="'.$STR_SENDOUT.'" '.$alert.'><img border="0" src="/images/send.gif" width="24" height="24"></a><span id="idsend_'.$id_send.'"></span></td>';
		print '</tr>';	
	}
  
print <<TABLE2   
</table><br>
<select size="1" name="action">
<option value="0">--$STR_ACTION--</option>
<option value="1">$STR_ACTIVATE</option>
<option value="2">$STR_DEACTIVATE</option>
<option value="3">$STR_REMOVE</option>
</select>&nbsp;
<input type="submit" id="Apply_" value="$BUTTON_APPLY" disabled="" name="">
TABLE2
;
  
	$query->finish(); 
  
	my $query = $dbh->prepare("SELECT count(*) FROM ".Constants::DB_SEND."");
	$query->execute() or die("Error executing SQL query!");
	my $count = $query->fetchrow_arrayref()->[0];
  
	$query->finish();
  
	my $number = int(($count - 1) / $row_setting->{'number_pos'}) + 1;

	my ($pervpag,$nextpage);
	
	if($page != 1)
	{  
		$pervpage = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page=1>&lt;&lt;</a> 
					<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'>&lt;</a> '; 
	}

	if($page != $number)
	{ 
		$nextpage = ' <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page + 1).'>&gt;</a> 
					<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.$number.'>&gt;&gt;</a>'; 
	}

	if(($page - 2) > 0) { $page2left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 2).'>...'.($page - 2).'</a> | '; }
	if(($page - 1) > 0) { $page1left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'>'.($page - 1).'</a> | '; }
	if(($page + 2) <= $number) { $page2right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page + 2).'>'.($page + 2).'...</a>'; }
	if(($page + 1) <= $number) { $page1right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page + 1).'>'.($page + 1).'</a>'; }
  
	print '<div class="pagination">'.$STR_PAGES.': ';
	print $pervpage.$page2left.$page1left.'<b>'.$page.'</b>'.$page1right.$page2right.$nextpage.'</div>';
  
	require 'lib/_bottom.pl' or die('Не возможно открыть файл "_bottom.pl"!');
}
else{
	my @temp = ();
	
	foreach (@activate)
	{ 
		if($_ =~ /^[\d]+$/) { $temp[@temp] = $_; }
	}
	
	if($action == 1){
		my $query = $dbh->prepare("UPDATE ".Constants::DB_SEND." SET active='yes' WHERE id_send IN (".join(",",@temp).")");
		$query->execute() or die('Error executing SQL query!');

		$query->finish();	
		
		redirect($MSG_ADD_CHANGES,$ENV{'HTTP_REFERER'},2); 
	}
	elsif($action == 2) {
		
		my $query = $dbh->prepare("UPDATE ".Constants::DB_SEND." SET active='no' WHERE id_send IN (".join(",",@temp).")");
		$query->execute() or die('Error executing SQL query!');
		$query->finish();	
		
		redirect($MSG_ADD_CHANGES,$ENV{'HTTP_REFERER'},2);		
	}
	elsif($action == 3) {
		my $delete = $dbh->prepare("DELETE FROM ".Constants::DB_SEND." WHERE id_send IN (".join(",",@temp).")");
		$delete->execute() or die("Error executing SQL query!");
		$delete->finish();
		
		my $delete = $dbh->prepare("DELETE FROM ".Constants::DB_ATTACH." WHERE id_send IN (".join(",",@temp).")");
		$delete->execute() or die('Error executing SQL query!');
		$delete->finish();
		
		redirect($MSG_ADD_CHANGES,$ENV{'HTTP_REFERER'},2);
	}
	else{
		redirect($MSG_ADD_CHANGES,$ENV{'HTTP_REFERER'},2);
	}
}

$dbh->disconnect();