# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

return true;

sub trim
{
	my $string = shift(@_);
	$string =~ s/^\s+|\s+$//g;
	return $string; 
}

sub invert_comas
{
	my $string = shift(@_);
	$string =~ s/'/`/g;
	$string =~ s/"/&quot;/g; 
	return $string; 
}

sub htmlspecialchars
{
	my $string = shift(@_);
	$string =~ s/<([^>]*)/($1 eq "BR" || $msg eq "br" ) ? "<$1>" : "\&lt$msg\&gt"/ge;
	return $string;
}

sub getRandomCod
{
	my $maxcount = 32;
	my $rand37 = "0123456789abcdef";
	my $RandCod = "";

	for($count = 0; $count < $maxcount; $count++){
		$RandCod .= substr($rand37, int(rand(15)), 1);
	}

	return $RandCod;
}

sub error
{
	my $string = shift(@_);
	print "<!DOCTYPE HTML>\n";
	print "<html>\n";
	print "<head>\n";
	print "<meta HTTP-EQUIV='Refresh' CONTENT='$delay; URL=$redirect'>\n";
	print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n";
	print "<link rel=\"StyleSheet\" type=\"text/css\" href=\"http://$ENV{'SERVER_NAME'}/style.css\">\n";
	print "<title>ERROR</title>\n";
	print "</head>\n";
	print "<body>\n";
	print "<span class=\"error\">".$string."</span><br><br>\n";
	print "<a href=javascript:history.go(-1);>".$STR_RETURN_BACK."</a>\n";
	print "</body>\n";
	print "</html>";
	
	exit;
}

sub root
{
	my $string = dirname($ENV{SCRIPT_NAME});
	if($string eq '/' or $string eq '\\') { return '/'; }
	else { return $string.'/'; }
}

sub check_kir
{
	my $string = shift(@_);  

	setlocale(LC_CTYPE,'ru_RU.utf8');
	
	if($string !~/[а-я]+/i){
		return false;
	}
	 
	return true;
}
  
sub Get_File_Name
{
	if($ENV{'HTTP_LISER_AGENT'} =~ /win/i){
		fileparse_set_fstype("MSDOS");
	}
	elsif($ENV{'HTTP_LISER_AGENT'} =~ /mac/i){
		fileparse_set_fstype("MacOS");
	}
		 
	my $full_name = shift;
	$full_name = base($full_name);
	$full_name =~ s!\s!\_!g;
	return($full_name);
}

sub redirect
{
	my $msg = shift(@_);
	my $redirect = shift(@_);
	my $delay = shift(@_); 
	
	print "<!DOCTYPE HTML>\n";
	print "<html>\n";
	print "<head>\n";
	print "<meta HTTP-EQUIV='Refresh' CONTENT='$delay; URL=$redirect'>\n";
	print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n";
	print "</head><body>\n";
	print '<link rel="StyleSheet" type="text/css" href="/style.css">';
	print '<div class="block-on-center">';
	print "$msg";
	print "</div>\n";
	print "</body>\n";
	print "</html>";
	
	exit;
}

sub check_email
{
	my $email = shift(@_);
	
	if($email !~ /^[a-zA-Z0-9._\%+-]+\@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/){
		return false;
	}
	else{
		return true;
	}	
} 

sub charsetlist
{
	my $string = shift(@_);

	$string =~ s/^utf\-8$/$CHARUTF8/ig;
	$string =~ s/^iso\-8859\-1$/$ISO88591/ig;
	$string =~ s/^iso\-8859\-2$/$ISO88592/ig;
	$string =~ s/^iso\-8859\-3$/$ISO88593/ig;
	$string =~ s/^iso\-8859\-4$/$ISO88594/ig;
	$string =~ s/^iso\-8859\-5$/$ISO88595/ig;
	$string =~ s/^koi8\-r$/$KOI8R/ig;
	$string =~ s/^koi8\-u$/$KOI8U/ig;	
	$string =~ s/^iso\-8859\-6$/$ISO88596/ig;	
	$string =~ s/^iso\-8859\-8$/$ISO88598/ig;	
	$string =~ s/^iso\-8859\-7$/$ISO88597/ig;
	$string =~ s/^iso\-8859\-9$/$ISO88599/ig;
	$string =~ s/^iso\-8859\-10$/$ISO885910/ig;
	$string =~ s/^iso\-8859\-13$/$ISO885913/ig;	
	$string =~ s/^iso\-8859\-14$/$ISO885914/ig;
	$string =~ s/^iso\-8859\-15$/$ISO885915/ig;
	$string =~ s/^iso\-8859\-16$/$ISO885916/ig;
	$string =~ s/^windows\-1250$/$WINDOWS1250/ig;	
	$string =~ s/^windows\-1251$/$WINDOWS1251/ig;	
	$string =~ s/^windows\-1252$/$WINDOWS1252/ig;
	$string =~ s/^windows\-1253$/$WINDOWS1253/ig;
	$string =~ s/^windows\-1254$/$WINDOWS1254/ig;
	$string =~ s/^windows\-1255$/$WINDOWS1255/ig;
	$string =~ s/^windows\-1256$/$WINDOWS1256/ig;	
	$string =~ s/^windows\-1257$/$WINDOWS1257/ig;
	$string =~ s/^windows\-1258$/$WINDOWS1258/ig;	
	$string =~ s/^gb2312$/$GB2312/ig;
	$string =~ s/^big5$/$BIG5/ig;	
	$string =~ s/^iso-2022\-jp$/$ISO2022JP/ig;
	$string =~ s/^ks_c_5601\-1987$/$KSC56011987/ig;
	$string =~ s/^euc\-kr$/$EUCKR/ig;	
	$string =~ s/^windows\-874$/$WINDOWS874/ig;	

	return $string;
}

sub send_mail {
	my $to = $_[0];
	my $header = $_[1];
	my $body = $_[2];

	my $smtp_host = ($row_setting->{'send_server'} == 2 ? $row_setting->{'smtp_host'} : 'localhost'); 
	
	my $smtp;
	if($row_setting->{'smtp_ssl'} eq 'no') {
		if(not $smtp = Net::SMTP->new($smtp_host,Timeout => $row_setting->{'smtp_timeout'},Port => $row_setting->{'smtp_port'})){
			return 500;
			exit;
		}		
	}
	else{
		if(not $smtp = Net::SMTP::SSL->new($smtp_host,Timeout => $row_setting->{'smtp_timeout'},Port => $row_setting->{'smtp_port'})){
			return 500;
			exit;
		}
	}
	
	if($row_setting->{'send_server'}  == 2){
		if(!$smtp->auth($row_setting->{'smtp_username'}, $row_setting->{'smtp_password'})){
			return 501;
			exit;
		}
	}

	$smtp->mail($row_setting->{'email'}); # use the sender's address here
	$smtp->to($to); # recipient's address
	$smtp->data(); # Start the mail

	$smtp->datasend($header."\n");
	$smtp->datasend("\n");
	
	# Send the body
	$smtp->datasend($body."\n");
	$smtp->dataend(); 
	$smtp->quit;
	
	return 300;
	exit;
}

sub encode_str {
	my $str = $_[0];
	my $charset = $_[1];
	
	$str = encode_base64($str);
	$str = "=?".$charset."?B?".$str."?=";
	$str =~ s/(\r\n)|(\n)//g;

	return $str;
}