#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use File::Basename;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use locale;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';

use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');
  
my %GET;
my @pairs = split(/&/, $ENV{"QUERY_STRING"});

foreach (@pairs)
{
	my ($name, $value) = split(/=/, $_);
	$GET{$name} = $value;
	$value = uri_unescape($value);
}

$title = $log_TITLE_PAGE;

my $page = int($GET{'page'});

if($page == 0) { $page = 1; }
my $number_pos = 20;
$begin = ($page - 1)*$number_pos;

require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');

my $query = $dbh->prepare("SELECT *,DATE_FORMAT(time,'%d.%m.%Y %H:%i') as send_time FROM ".Constants::DB_LOG." ORDER BY id_log desc LIMIT $begin, $number_pos");
$query->execute() or die("Error executing SQL query!");

print <<HTML1
<table class="cattab content" cellspacing="1" cellpadding="3" border="0" width="100%">
<tr align="center">
<th class="catmenu">$TH_TABLE_TIME</th>
<th class="catmenu">$TH_TABLE_SEND</th>
</tr>
HTML1
; 

while(my $row = $query->fetchrow_hashref())
{
	print '<tr class="trcat">';
	print '<td>'.$row->{'send_time'}.'</td>';
	print '<td>'.$row->{'count'}.'</td>';
	print '</tr>';
}

$query->finish();

print '</table>';

my $query = $dbh->prepare("SELECT COUNT(*) FROM ".Constants::DB_LOG."");
$query->execute() or die("Error executing SQL query!");
my $count = $query->fetchrow_arrayref()->[0];
  
$query->finish();
 
my $number = int(($count - 1) / $number_pos) + 1;

my ($pervpag,$nextpage);
	
if($page != 1){  
	$pervpage = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page=1>&lt;&lt;</a> 
				 <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'>&lt;</a> '; 
}
  
if($page != $number){ 
	$nextpage = ' <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page + 1).'>&gt;</a> 
				<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.$number.'>&gt;&gt;</a>'; 
}

if(($page - 2) > 0) { $page2left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 2).'>...'.($page - 2).'</a> | '; }
if(($page - 1) > 0) { $page1left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'>'.($page - 1).'</a> | '; }
if(($page + 2) <= $number) { $page2right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 2).'>'.($page + 2).'...</a>'; }
if(($page + 1) <= $number) { $page1right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 1).'>'.($page + 1).'</a>'; }
  
print '<div class="pagination">Страницы: ';
print $pervpage.$page2left.$page1left.'<b>'.$page.'</b>'.$page1right.$page2right.$nextpage.'</div>';

require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');

$dbh->disconnect(); 