#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use File::Basename;
use Encode;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
  
use lib "../";
use Constants;
use ConnectDB;
use GetSetting;

require 'lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Cannot open the file "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');
  
$title = $SETTINGS_TITLE_PAGE;
  
my $action = param("action");
  
if($action eq ''){
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
	
	my $show_email_checked = ($row_setting->{'show_email'} eq "yes" ? ' checked="checked"': "");
	my $newsubscribernotify_checked = ($row_setting->{'newsubscribernotify'} eq "yes" ? ' checked="checked"': "");
	my $name_from = ($row_setting->{'name_from'} eq '' ? $ENV{'SERVER_NAME'} : htmlspecialchars($row_setting->{'name_from'}));
	$row_setting->{'organization'} = htmlspecialchars($row_setting->{'organization'});
	
	my $smtp_ssl_checked = ($row_setting->{'smtp_ssl'} eq "yes" ? ' checked="checked"': "");
	my $smtp_aut_1_checked = ($row_setting->{'smtp_aut'} == 1 ? ' checked="checked"': "");
	my $smtp_aut_2_checked = ($row_setting->{'smtp_aut'} == 1 ? ' checked="checked"': "");
	my $unsubscribe_checked = ($row_setting->{'unsubscribe'} eq "yes" ? ' checked="checked"': "");
	my $reply_checked = ($row_setting->{'reply'} eq "yes" ? ' checked="checked"': "");

	my $type_interval;
	$type_interval = '<select name="type_interval">';
	$type_interval .= '<option value="0"'.($row_setting->{'type_interval'} eq "no" ? ' selected="selected"' : '').'>'.$STR_NO.'</option>';
	$type_interval .= '<option value="1"'.($row_setting->{'type_interval'} eq "m" ? ' selected="selected"' : '').'>'.$STR_MINUTS.'</option>';
	$type_interval .= '<option value="2"'.($row_setting->{'type_interval'} eq "h" ? ' selected="selected"' : '').'>'.$STR_HOURS.'</option>';
	$type_interval .= '<option value="3"'.($row_setting->{'type_interval'} eq "d" ? ' selected="selected"' : '').'>'.$STR_DAYS.'</option>';
	$type_interval .= '</select>';
	
	my $re_send_checked = ($row_setting->{'re_send'} eq "yes" ? ' checked="checked"': "");
	my $send_limit_checked = ($row_setting->{'limit_send'} eq "yes" ? ' checked="checked"': "");
	my $del_checked = ($row_setting->{'delete_subs'} eq "yes" ? ' checked="checked"': "");
	my $show_list_id_checked = ($row_setting->{'show_list_id'} eq "yes" ? ' checked="checked"': "");
	
	my $precedence_option = '<select name="precedence">';
	$precedence_option .= '<option value="no"'.($row_setting->{'precedence'} eq "no" ? ' selected="selected"' : '').'>'.$STR_NO.'</option>';
	$precedence_option .= '<option value="bulk"'.($row_setting->{'precedence'} eq "bulk" ? ' selected="selected"' : '').'>bulk</option>';
	$precedence_option .= '<option value="junk"'.($row_setting->{'precedence'} eq "junk" ? ' selected="selected"' : '').'>junk</option>';
	$precedence_option .= '<option value="list"'.($row_setting->{'precedence'} eq "list" ? ' selected="selected"' : '').'>list</option>';
	$precedence_option .= '</select>';
	 
print <<HTML1
<script type="text/javascript">

function smtp(form)
{
	if(form.smtp_host.value == '') { alert("$ERR_EMPTY_SMTP_HOST"); }
	if(form.smtp_port.value == '') { alert("$ERR_EMPTY_SMTP_PORT"); }
}

function dflt()
{
	document.forms[0].number_pos.value = 5;
	document.forms[0].number_pos_users.value = 20;
	document.forms[0].organization.value = '';
	document.forms[0].email.value = 'admin\@gmail.com';
	document.forms[0].subjecttextconfirm.value = '$STR_SET_SUBJECTTEXTCONFIRM';
	document.forms[0].textconfirmation.value = '$STR_SET_TEXTCONFIRMATION';
	document.forms[0].unsublink.value = '$STR_SET_UNSUBLINK';
	document.forms[0].smtp_host.value = 'smtp.gmail.com';
	document.forms[0].smtp_ssl.checked = false;
	document.forms[0].unsubscribe.checked = true;
	document.forms[0].show_list_id.checked = true;
	document.forms[0].reply.checked = false;
	document.forms[0].type_interval.value = 0;
	document.forms[0].number_interval.value = 1;
	document.forms[0].re_send.checked = true;
	document.forms[0].delete_subs.checked = true;
	document.forms[0].number_days.value = 7;
	document.forms[0].content_type.value = 1;
	document.forms[0].send_server[0].checked = true;
	document.forms[0].smtp_username.value = '';
	document.forms[0].smtp_password.value = '';
	document.forms[0].smtp_port.value = 25;
	document.forms[0].smtp_timeout.value = 10;
	document.forms[0].precedence.value = 'bulk';
}

</script>
<div class="tableform">
<form action="settings.pl" method="post">
<table border="0" width="1050">
<tr><td colspan="2"><b>$STR_INTERFACE_SETTINGS</b><hr></td></tr>
<tr><td width="40%">$STR_LANGUAGE:</td><td>
HTML1
;
	print '<select name="language">';

	if($row_setting->{'language'} eq "en"){
		print '<option value="en" selected="selected">'.$STR_LANGUAGE_EN.'</option>';
	}
	else{
		print '<option value="en">'.$STR_LANGUAGE_EN.'</option>';
	}
	
	if($row_setting->{'language'} eq "ru"){
		print '<option value="ru" selected="selected">'.$STR_LANGUAGE_RU.'</option>';
	}
	else{
		print '<option value="ru">'.$STR_LANGUAGE_RU.'</option>';
	}

	print '</select>';
	
print <<HTML2
</td></tr>

<tr><td width="40%">$STR_NUMBER_POS:</td><td><input type="text" class="input" name="number_pos" size="3" maxlength="4" value="$row_setting->{'number_pos'}"></td></tr>
<tr><td width="40%">$STR_NUMBER_POS_USERS:</td><td><input class="input" type="text" name="number_pos_users" size="3" maxlength="4" value="$row_setting->{'number_pos_users'}"></td></tr>
<tr><td width="40%">E-mail:</td><td><input class="input" type=text name="email" size="45" maxlength="100" value="$row_setting->{'email'}"></td></tr>
<tr><td width="40%">$STR_SHOW_EMAIL:</td><td><input type=checkbox name="show_email"$show_email_checked></td></tr>
<tr><td width="40%">$STR_NEWSUBSCRIBERNOTIFY:</td><td><input type=checkbox name="newsubscribernotify"$newsubscribernotify_checked></td></tr>
<tr><td width="40%">$STR_ORGANIZATION:</td><td><input class="input" type=text name="organization" size="45" maxlength="100" value="$row_setting->{'organization'}"></td></tr>
<tr><td width="40%">$STR_SUBJECTTEXTCONFIRM:</td><td><input class="input" type=text name="subjecttextconfirm" size="45" maxlength="100" value="$row_setting->{'subjecttextconfirm'}"><br></td></tr>
<tr><td width="40%">$STR_TEXTCONFIRMATION:</td><td><textarea rows="5" name="textconfirmation" cols="25">$row_setting->{'textconfirmation'}</textarea></td></tr>
<tr><td width="40%">$STR_UNSUBLINK:</td><td><textarea rows="3" name="unsublink" cols="25">$row_setting->{'unsublink'}</textarea></td></tr>
<tr><td colspan="2">$STR_NOTE</td></tr>
<tr><td colspan="2"><b>$STR_SMTP_SERVER_SETTINGS</b><hr></td></tr>
<tr><td width="40%">$STR_SMTP_HOST:</td><td><input class="input" type=text name="smtp_host" size="45" maxlength="100" value="$row_setting->{'smtp_host'}"></td></tr>
<tr><td width="40%">$STR_SMTP_USERNAME:</td><td><input class="input" type=text name="smtp_username" size="45" maxlength="100" value="$row_setting->{'smtp_username'}"></td></tr>
<tr><td width="40%">$STR_SMTP_PASSWORD:</td><td><input class="input" type=text name="smtp_password" size="45" maxlength="100" value="$row_setting->{'smtp_password'}"></td></tr>
<tr><td width="40%">$STR_SMTP_PORT:</td><td><input class="input" type=text name="smtp_port" size="6" maxlength="20" value="$row_setting->{'smtp_port'}"></td></tr>
<tr><td width="40%">$STR_SMTP_TIMEOUT:</td><td><input class="input" type=text name="smtp_timeout" size="6" maxlength="20" value="$row_setting->{'smtp_timeout'}"></td></tr>
<tr><td width="40%">$STR_SMTP_SSL_CHECKED:</td><td><input type=checkbox name="smtp_ssl"$smtp_ssl_checked></td></tr>
<tr><td colspan="2"><b>$STR_SEND_OPTION</b><hr></td></tr>
<tr><td width="40%">$STR_UNSUBSCRIBE_CHECKED:</td><td><input type=checkbox name="unsubscribe"$unsubscribe_checked></td></tr>
<tr><td width="40%">$STR_SHOW_LIST_ID_CHECKED:</td><td><input type=checkbox name="show_list_id"$show_list_id_checked></td></tr>
<tr><td width="40%">$STR_REPLY_CHECKED:</td><td><input type=checkbox name="reply"$reply_checked></td></tr>
<tr><td width="40%">$STR_MAILINGS_INTERVAL,$type_interval:</td><td><input class="input" type="text" name="number_interval" size="3" maxlength="4" value="$row_setting->{'number_interval'}"></td></tr>
<tr><td width="40%">$STR_RE_SEND_CHECKED:</td><td><input type=checkbox name="re_send"$re_send_checked></td></tr>
<tr><td>$STR_NUMBER_LIMIT: <input size="2" type=text name="number_limit" size="3" maxlength="4" value="$row_setting->{'number_limit'}"></td>
<td><input type="checkbox" name="limit_send"$send_limit_checked></td></tr>
<tr><td>$STR_DELETE_UNACTIVE_SUBRS:&nbsp;<input size="2" type=text name="number_days" size="3" maxlength="4" value="$row_setting->{'number_days'}"></td>
<td><input type="checkbox" name="delete_subs" $del_checked></td></tr>
<tr><td width="40%">Precedence:</td><td>$precedence_option</td></tr>
<tr><td width="40%">$STR_EMAIL_CHARSET:</td>
<td> 
HTML2
;

	print '<select id="charset" name="id_charset">';

	my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CHAR."");
	$query->execute() or die("Error executing SQL query!");
  
	my %temp = ();
  
	while(my $row = $query->fetchrow_hashref())
	{
		$temp{$row->{'id_charset'}} = charsetlist($row->{'charset'});		
	}
  
	$query->finish();

#asort($temp);

while (($key,$value) = each(%temp))
{
	$selected = ($key eq $row_setting->{'id_charset'} ? 'selected="selected" ' : "");
	print "<option ".$selected."value=\"".$key."\">".$value."</option>";
}

print '</select>';

my $plain_selected = ($row_setting->{'content_type'} == 1 ? ' selected="selected"': "");
my $html_selected = ($row_setting->{'content_type'} == 2 ? ' selected="selected"': "");
my $send_server_1_checked = ($row_setting->{'send_server'} == 1 ? ' checked="checked"': "");
my $send_server_2_checked = ($row_setting->{'send_server'} == 2 ? ' checked="checked"': "");

print <<HTML3
</td>
</tr>
<tr><td>$STR_EMAIL_CONTENT_TYPE:</td>
<td><select name="content_type">
<option value="1"$plain_selected>plain</option>
<option value="2"$html_selected>html</option>
</select>
</td>
</tr>
<tr><td>$STR_SEND_EMAIL_VIA:</td>
<td><input type="radio" value="1"$send_server_1_checked name="send_server">localhost&nbsp;<input type="radio" onChange="smtp(this.form);" name="send_server"$send_server_2_checked value="2">$STR_SMTP_HOST</td>
</tr>
<tr><td>&nbsp;</td><tr><td><input class="inputsubmit" type="submit" value="$BUTTON_ADD_CHANGES">&nbsp;&nbsp;<input class="inputsubmit" type="button" value="$BUTTON_BY_DEFAULT" onclick="dflt()">
<input type="hidden" name="action" value="post">
</td>
</tr></table></form>
</div>
HTML3
;

	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"');
}
else{
	my $number_pos = int(trim(param("number_pos")));
	my $number_pos_users = int(trim(param("number_pos_users")));
	my $organization = trim(param("organization"));
	my $email = trim(param("email"));
	my $smtp_host = trim(param("smtp_host"));
	my $smtp_username = trim(param("smtp_username"));
	my $smtp_password = trim(param("smtp_password"));
	my $smtp_port = int(trim(param("smtp_port")));
	my $smtp_timeout = int(trim(param("smtp_timeout")));
	my $content_type = int(trim(param("content_type")));
	my $send_server = int(trim(param("send_server")));
	my $id_charset = int(trim(param("id_charset")));
	my $number_days = int(trim(param("number_days")));
	my $number_limit = int(trim(param("number_limit")));
	my $subjecttextconfirm = trim(param("subjecttextconfirm"));
	my $textconfirmation = trim(param("textconfirmation"));
	my $unsublink = trim(param("unsublink"));
	my $number_interval = int(trim(param("number_interval")));
	
	$from =~ s/;//g;

	if($number_pos !~ /^[\d]*$/) { $number_pos = $settings->{'number_pos'}; }
	if($number_pos_users !~ /^[\d]*$/) { $number_pos_users = $settings->{'number_pos_users'}; }
	if($smtp_port !~ /^[\d]*$/) { $smtp_port = $settings->{'smtp_port'}; }
	if($id_charset !~ /^[\d]*$/) { $id_charset = $settings->{'id_charset'}; }
	if($number_days !~ /^[\d]*$/) { $number_days = $settings->{'number_days'}; }
	if($number_limit !~ /^[\d]*$/) { $number_limit = $settings->{'number_limit'}; }	
	if($content_type !~ /^[\d]*$/) { $content_type = $settings->{'content_type'}; }	
	if($send_server !~ /^[\d]*$/) { $send_server = $settings->{'send_server'}; }
	if($number_interval !~ /^[\d]*$/) { $number_interval = $settings->{'number_interval'}; }
	 
	$organization = invert_comas(trim(param("organization")));
	$email = invert_comas(trim(param("email")));
	$smtp_host = invert_comas(trim(param("smtp_host")));
	$smtp_username = invert_comas(trim(param("smtp_username")));
	$smtp_password = invert_comas(trim(param("smtp_password")));
	$subjecttextconfirm = invert_comas(trim(param("subjecttextconfirm")));
	$textconfirmation = invert_comas(trim(param("textconfirmation")));
	$unsublink = invert_comas(trim(param("unsublink")));
	$precedence = invert_comas(trim(param("precedence")));
	
	my $language = param("language");
	my $show_email = (param("show_email") eq "on" ? "yes" : "no");
	my $smtp_ssl = (param("smtp_ssl") eq "on" ? "yes" : "no");
	my $limit_send = (param("limit_send") eq "on" ? "yes" : "no");
	my $re_send = (param("re_send") eq "on" ? "yes" : "no");
	my $delete_subs = (param("delete_subs") eq "on" ? "yes" : "no");
	my $reply = (param("reply") eq "on" ? "yes" : "no");
	my $unsubscribe = (param("unsubscribe") eq "on" ? "yes" : "no");
	my $newsubscribernotify = (param("newsubscribernotify") eq "on" ? "yes" : "no");
	my $show_list_id = (param("show_list_id") eq "on" ? "yes" : "no");
	
	my $type_interval;
	if(param("type_interval") == 1) { $type_interval  = 'm';  }
	elsif (param("type_interval") == 2) { $type_interval = 'h'; }
	elsif (param("type_interval") == 3) { $type_interval = 'd'; }
	else { $type_interval = 'no'; }	
	
	$sql = "UPDATE ".Constants::DB_SETTINGS." SET number_pos=".$number_pos.",
													language = '".$language."',
													number_pos_users=".$number_pos_users.",
													organization='".$organization."',
													email='".$email."',
													show_email='".$show_email."',
													send_server='".$send_server."',
													content_type='".$content_type."',
													smtp_host='".$smtp_host."',
													smtp_username='".$smtp_username."',
													smtp_password='".$smtp_password."',
													smtp_port=".$smtp_port.",
													smtp_ssl='".$smtp_ssl."',
													smtp_timeout=".$smtp_timeout.", 
													id_charset=".$id_charset.",
													number_days=".$number_days.",
													limit_send='".$limit_send."',
													number_limit=".$number_limit.",
													re_send='".$re_send."',
													delete_subs='".$delete_subs."',
													reply='".$reply."',
													unsubscribe='".$unsubscribe."',
													subjecttextconfirm='".$subjecttextconfirm."',
													textconfirmation='".$textconfirmation."',
													textconfirmation='".$textconfirmation."',
													unsublink='".$unsublink."',
													newsubscribernotify='".$newsubscribernotify."',
													type_interval='".$type_interval."',
													number_interval=".$number_interval.",
													show_list_id='".$show_list_id."',
													precedence='".$precedence."'
													";
		
	my $query = $dbh->prepare($sql);
	$query->execute() or die("Error executing SQL query!");
	  
	$query->finish();  
	  
	redirect($MSG_ADD_CHANGES,"settings.pl",2);
}
	
$dbh->disconnect();  