#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use File::Basename;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use locale;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';

use lib "../";
use Constants;
use ConnectDB;
use GetSetting;
  
require 'lib/_functions.pl' or die('Не возможно открыть файл "_functions.pl"!');
require 'language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'lib/_authenticate.pl' or die('Не возможно открыть файл "_authenticate.pl"!');
require 'lib/_delete.pl' or die('Не возможно открыть файл "_delete.pl"!');
  
my %GET;
my @pairs = split(/&/, $ENV{"QUERY_STRING"});

foreach (@pairs)
{
	my ($name, $value) = split(/=/, $_);
	$GET{$name} = $value;
	$value = uri_unescape($value);
}
  
$search = invert_comas(trim(uri_unescape($GET{'search'})));
  
$title = $SUBSCRIBERS_TITLE_PAGE;

my @activate = param('activate[]');
my $action = param("action");
my $tmp;

if($action eq ''){
	my $page = int($GET{'page'});

	if($page == 0) { $page = 1; }
	if($row_setting->{'number_pos_users'} == 0) { $row_setting->{'number_pos_users'} = 10; }
	$begin = ($page - 1)*$row_setting->{'number_pos_users'};
  
	require 'lib/_top.pl' or die('Cannot open the file "_top.pl"!');
  
	my $query;
  
	if($search eq ''){
		$sql = "SELECT *,DATE_FORMAT(time,'%d.%m.%y') AS putdate_format FROM ".Constants::DB_USERS." ORDER by name LIMIT ".$begin.", ".$row_setting->{'number_pos_users'}."";
	}
	else{
		my @temp = split(" ", $search);
		my $logstr = "or";
		
		
		foreach (@temp)
		{
			if($is_query) { $tmp .= " ".$logstr." (name LIKE '%".$_."%' OR email LIKE '%".$_."%') "; }
			else { $tmp .= "(name LIKE '%".$_."%' OR email LIKE '%".$_."%') "; }

			my $is_query = true;
		}

		$sql = "SELECT *,DATE_FORMAT(time,'%d.%m.%y') as putdate_format FROM ".Constants::DB_USERS."
					WHERE ".$tmp."
					GROUP BY id_user
					ORDER BY name
					LIMIT ".$begin.", ".$row_setting->{'number_pos_users'}."";
	}
	
	$query = $dbh->prepare($sql);
	$query->execute() or die("$sql Error executing SQL query!");
  
print <<HTML1
<script type="text/javascript">

var DOM = (typeof(document.getElementById) != 'undefined');

function Check_action()
{
	if(document.forms[1].action.value==0) {window.alert('Выберите действие!');}
}

function CheckAll_Activate(Element,Name)
{
	if(DOM)
	{
		thisCheckBoxes = Element.parentNode.parentNode.parentNode.getElementsByTagName('input');

		var m=0;

		for(var i=1; i < thisCheckBoxes.length; i++)
		{
			if(thisCheckBoxes[i].name == Name)
			{
				thisCheckBoxes[i].checked = Element.checked;
				if(thisCheckBoxes[i].checked == true) m++;
				if(thisCheckBoxes[i].checked == false) m--;
			}
		}

		if(m > 0) { document.getElementById("Apply_").disabled = false; }
		else { document.getElementById("Apply_").disabled = true;  }
	}
}

function Count_checked()
{
	var All=document.forms[1];

	var m=0;

	for(var i=0; i < All.elements.length; ++i)
	{
		if(All.elements[i].checked) { m++; }
	}

	if(m > 0) { document.getElementById("Apply_").disabled = false; }
	else { document.getElementById("Apply_").disabled = true; }
}

</script>
<form class="search" action="subscribers.pl" method="GET">
<div class="tableform" style="width: 300px">
<table border="0">
<tr><td>$TH_TABLE_NAME_OR_EMAIL:</td><td><input size="20" type="text" value="$search" name="search"></td></tr>
<tr><td><input type="submit" class="inputsubmit" value="$BUTTON_FIND"></td>
<td></td>
</table>
</div>
</form>
<form action="subscribers.pl" onSubmit="if(document.forms[1].action.value==0){window.alert('$ERR_NOT_CHOOSE_ACTION');return false;}if(document.forms[1].action.value==2){return confirm('$QUESTION_CONFIRM_REMOVE');}" method="post">
<table class="cattab content" cellSpacing="1" cellPadding="5" border="0" width="100%"><tr>
<th class="catmenu toptab"><input type="checkbox" title="$STR_SELECT_ALL/$STR_DESELECT_ALL" onclick="CheckAll_Activate(this,'activate[]');"></td>
<th width="350" class="catmenu toptab">$TH_TABLE_USERNAME</td>
<th width="350" class="catmenu toptab">E-mail</td>
<th width="300" class="catmenu toptab">IP</td>
<th class="catmenu">$TH_TABLE_ADDED</td>
<th class="catmenu toptab">$TH_TABLE_STATUS</td>
<th class="catmenu toptab">$TH_TABLE_EDIT</td>
</tr>
HTML1
;  
	 
	while(my $row = $query->fetchrow_hashref())
	{
		my $str_stat = ($row->{'status'} eq 'active' ? $STR_ACTIVE : $STR_NOACTIVE);
	
		if($row->{'status'} eq 'active'){
			print '<tr onMouseOver="this.style.background=\'#D2FFD2\';" onMouseOut="this.style.background=\'#eeeeee\';" class=trcat>';
		}
		else{
			print '<tr class="trcat2" onMouseOver="this.style.background=\'#FD733E\';" onMouseOut="this.style.background=\'#FEC5AF\';">';
		}	
	
		print '<td align=center><input type="checkbox" onclick="Count_checked();" title="'.$STR_SELECT.'/'.$STR_DESELECT.'" value="'.$row->{'id_user'}.'" name=activate[]></td>';
		print '<td>'.$row->{'name'}.'</td>';
		print '<td>'.$row->{'email'}.'</td>';
		print '<td align=center>'.$row->{'ip'}.'</td>';
		print '<td align=center>'.$row->{'putdate_format'}.'</td>';
		print '<td align=center>'.$str_stat.'</td>';
		print '<td align=center><a href="edituser.pl?id_user='.$row->{id_user}.'" title="'.$STR_EDIT_SUBSCRIBER.'">'.$STR_EDIT.'</a></td></tr>';
	}

	$query->finish();
  
print <<HTML3
</table>
<select class="action" size="1" name="action">
<option value="0">--$STR_ACTION--</option>
<option value="1">$STR_ACTIVATE</option>
<option value="2">$STR_REMOVE</option>
</select>&nbsp;
<input type="submit" id="Apply_" value="$BUTTON_APPLY" disabled="" name="">
</form>
HTML3
;

	if($search eq '')
	{
		my $query = $dbh->prepare("SELECT COUNT(*) FROM ".Constants::DB_USERS."");
		$query->execute() or die("Error executing SQL query!");
		my $count = $query->fetchrow_arrayref()->[0];
  
		$query->finish();
 
		my $number = int(($count - 1) / $row_setting->{'number_pos_users'}) + 1;
		my ($pervpag,$nextpage);
	
		if($page != 1)
		{  
			$pervpage = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page=1>&lt;&lt;</a> 
						<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'>&lt;</a> '; 
		}
  
		if($page != $number)
		{ 
			$nextpage = ' <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page + 1).'>&gt;</a> 
						<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.$number.'>&gt;&gt;</a>'; 
		}

		if(($page - 2) > 0) { $page2left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 2).'>...'.($page - 2).'</a> | '; }
		if(($page - 1) > 0) { $page1left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'>'.($page - 1).'</a> | '; }
		if(($page + 2) <= $number) { $page2right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 2).'>'.($page + 2).'...</a>'; }
		if(($page + 1) <= $number) { $page1right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 1).'>'.($page + 1).'</a>'; }
	}
	else{
		my $query = $dbh->prepare("SELECT COUNT(*) FROM ".Constants::DB_USERS." WHERE $tmp");
		$query->execute() or die("Error executing SQL query!");
		my $count = $query->fetchrow_arrayref()->[0];
  
		$query->finish();
		
		my $number = int(($count - 1) / $row_setting->{'number_pos_users'}) + 1;
		my ($pervpag,$nextpage);
	
		if($page != 1)
		{  
			$pervpage = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page=1&search='.$search.'>&lt;&lt;</a> 
						<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'&search='.$search.'>&lt;</a> '; 
		}
  
		if($page != $number)
		{ 
			$nextpage = ' <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page + 1).'&search='.$search.'>&gt;</a> 
						<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.$number.'&search='.$search.'>&gt;&gt;</a>'; 
		}

		if(($page - 2) > 0) { $page2left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 2).'&search='.$search.'>...'.($page - 2).'</a> | '; }
		if(($page - 1) > 0) { $page1left = '<a href=http://'.$ENV{"SERVER_NAME"}.$ENV{"SCRIPT_NAME"}.'?page='.($page - 1).'&search='.$search.'>'.($page - 1).'</a> | '; }
		if(($page + 2) <= $number) { $page2right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 2).'&search='.$search.'>'.($page + 2).'...</a>'; }
		if(($page + 1) <= $number) { $page1right = ' | <a href=http://'.$ENV{"SERVER_NAME"}.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 1).'&search='.$search.'>'.($page + 1).'</a>'; }
	}
  
	print '<div class="pagination">'.$STR_PAGES.': ';
	print $pervpage.$page2left.$page1left.'<b>'.$page.'</b>'.$page1right.$page2right.$nextpage.'</div>';

	require 'lib/_bottom.pl' or die('Cannot open the file "_bottom.pl"!');
}
else{
	my @temp = ();
	
	foreach (@activate)
	{ 
		if($_ =~ /^[\d]+$/) { $temp[@temp] = $_; }
	}
	
	if($action == 1){
		my $update = $dbh->prepare("UPDATE ".Constants::DB_USERS." SET status='active' WHERE id_user IN (".join(",",@temp).")");
		$update->execute() or die("Error executing SQL query!");
		$update->finish();
	
		redirect($MSG_ADD_CHANGES,$ENV{"HTTP_REFERER"},2);
	}
	elsif ($action == 2){
		my $delete = $dbh->prepare("DELETE FROM ".Constants::DB_USERS." WHERE id_user IN (".join(",",@temp).")");
		$delete->execute() or die("Error executing SQL query!");
		$delete->finish();
		
		my $delete = $dbh->prepare("DELETE FROM ".Constants::DB_SUB." WHERE id_user IN (".join(",",@temp).")");
		$delete->execute() or die("Error executing SQL query!");
		$delete->finish();
	
		redirect($MSG_ADD_CHANGES,$ENV{"HTTP_REFERER"},2);
	}
	else{
		redirect($MSG_ADD_CHANGES,$ENV{"HTTP_REFERER"},2);
	}
}

$dbh->disconnect(); 