#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use locale;
use POSIX;
use File::Basename;
use MIME::Base64;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use Encode;
use CGI qw(:standard);
  
use Net::SMTP;
use Net::SMTP::SSL;
use Constants;
use ConnectDB;
use GetSetting;

require 'admin/lib/_functions.pl' or die('Cannot open the file "_functions.pl"!');
require 'admin/language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');
require 'admin/lib/_delete.pl' or die('Cannot open the file "_delete.pl"!');

my $mailcount = 0;

my $query_charset = $dbh->prepare("SELECT * FROM ".Constants::DB_CHAR." WHERE id_charset=".$row_setting->{'id_charset'}."");
$query_charset->execute() or die("Error executing SQL query!");

my $row = $query_charset->fetchrow_hashref();
$charset = $row->{'charset'};

$query_charset->finish();

my $organization = $row_setting->{'organization'};

if($charset ne 'utf-8') {
	Encode::from_to($organization, 'utf-8', $charset);
}

my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_SEND." WHERE active='yes' ORDER BY pos");
$query->execute() or die("Error executing SQL query!");
	 
while(my $send = $query->fetchrow_hashref())
{
	my $subject = $send->{'name'};

	if($charset ne 'utf-8') {
		Encode::from_to($subject, 'utf-8', $charset);
	}	

	if(check_kir($subject, 'utf-8') eq true){
		$subject = encode_str($subject,$charset);
	}
	
	my $interval;
	
	if($row_setting->{'type_interval'} eq 'm'){
		$interval = "AND (time_send < NOW() - INTERVAL '".$row_setting->{'number_interval'}."' MINUTE)";
	}
	elsif($row_setting->{'type_interval'} eq 'h'){
		$interval = "AND (time_send < NOW() - INTERVAL '".$row_setting->{'number_interval'}."' HOUR)";
	}
	elsif($row_setting->{'type_interval'} eq 'd'){
		$interval = "AND (time_send < NOW() - INTERVAL '".$row_setting->{'number_interval'}."' DAY)";
	}
	else{
		$interval = '';
	}
	
	my $limit = ($row_setting->{'limit_send'} eq "yes" ? "LIMIT ".$row_setting->{'number_limit'}."" : "");	
	my $sql;
	
	if($row_setting->{'re_send'} eq "no") { 
		if($send->{'id_cat'} == 0){ 
			$sql = "SELECT *,u.id_user as id FROM ".Constants::DB_USERS." u 
							LEFT JOIN ".Constants::DB_READY." r ON u.id_user=r.id_user AND r.id_send=".$id_send." 
							WHERE (r.id_user IS NULL) AND (status='active') ".$interval." ".$limit."";		
		}
		else{
			$sql = "SELECT *,u.id_user as id FROM ".Constants::DB_USERS." u 
							LEFT JOIN ".Constants::DB_SUB." s ON u.id_user=s.id_user
							LEFT JOIN ".Constants::DB_READY." r ON u.id_user=r.id_user AND r.id_send=".$id_send." 
							WHERE (r.id_user IS NULL) AND (id_cat=".$send->{'id_cat'}.") AND (status='active') ".$interval." 
							".$limit."";	
		}	
	}
	else{
		if($send->{'id_cat'} == 0){ 
			$sql = "SELECT *,id_user as id FROM ".Constants::DB_USERS." WHERE status='active' ".$interval." ".$limit."";
		}
		else{
			$sql = "SELECT *,u.id_user as id FROM ".Constants::DB_USERS." u 
							LEFT JOIN ".Constants::DB_SUB." s ON u.id_user=s.id_user 
							WHERE (id_cat=".$send->{'id_cat'}.") AND (status='active') ".$interval." ".$limit."";	
		}
	}
	
	my $query_users = $dbh->prepare($sql);
	
	$query_users->execute() or die("Error executing SQL query!");	
	
	if($query_users->rows > 0){
	
		while(my $users = $query_users->fetchrow_hashref())
		{
			my $body = '';
			my $type = '';
		
			my $email = $users->{'email'};
			my $token = $users->{'token'};
			my $UNSUB = "http://".$ENV{'SERVER_NAME'}.$dir."unsubscribe.pl?id=".$users->{'id'}."&token=".$users->{'token'}."";
			my $smtp_host = ($row_setting->{'send_server'} == 2 ? $row_setting->{'smtp_host'} : 'localhost');  
		
			my $time_now = strftime("%Y-%m-%d %H:%M:%S", localtime);
			my $boundary = "--".md5_hex($time_now);
			
			my $header = "MIME-Version: 1.0\n";
			
			$sql = "SELECT * FROM ".Constants::DB_ATTACH." WHERE id_send=".$send->{'id_cat'};
			my $query_attach = $dbh->prepare($sql);
			$query_attach->execute() or die("Error executing SQL query!");		
	
			if($users->{'name'} ne ''){
				my $name = $users->{'name'};
			
				if(check_kir($name, 'utf-8') eq true){
					$name = encode_str($name,$charset);
				}
				
				$header .= "To: ".$name." <".$email.">\n";
			}
			else{
				$header .= "To:".$email."\n";
			}
			
			$header .= "Subject: ".$subject."\n";
			$header .= $row_setting->{'show_email'} eq "no" ? "From: noreply\@".$ENV{'SERVER_NAME'}."\n" : "From: ".$row_setting->{'email'}."\n";
			
			if($send->{'prior'} == 1){
				$header .= "X-Priority: 1\n";
			}
			elsif($send->{'prior'} == 3){
				$header .= "X-Priority: 5\n";
			}
			else{
				$header .= "X-Priority: 3\n";
			}

			my $unsublink = $row_setting->{'unsublink'};
			
			if($row_setting->{'reply'} eq "yes"){
				$header .= "Reply-To: ".$row_setting->{'email'}."\n";
				$header .= "Disposition-Notification-To: ".$row_setting->{'email'}."\n";
			}
		
			if($row_setting->{'unsubscribe'} eq "yes") { 
				$body .= "".$send->{'message'}."<br>".$unsublink.""; 
				$header .= "List-Unsubscribe: ".$UNSUB."\n";
			}
			else { $body .= $send->{'message'}; }
			
			$header .= $row_setting->{'precedence'} ne '' ? "Precedence: ".$row_setting->{'precedence'}."\n" : '';
			
			if($row_setting->{'organization'} ne ''){
				$header .= "Organization: $organization\n";
			}
		
			if($query_attach->rows>0) {
				$header .= "Content-Type: multipart/mixed; boundary=".$boundary."\n";
				$header .= "--".$boundary."\n";
				#$header .= "\n\n";
			}	

			
			$header .= $row_setting->{'content_type'} == 1 ? "Content-type: text/plain; charset=".$charset."\n" : "Content-type: text/html; charset=".$charset."\n";
			$header .= "Content-Transfer-Encoding: 8bit\n";
			
			$body =~ s/\%NAME\%/$users->{'name'}/mg;
			$body =~ s/\%DAYS\%/$row_setting->{'day'}/mg;
			$body =~ s/\%UNSUB\%/$UNSUB/mg;
			$body =~ s/\%SERVER_NAME\%/$ENV{'SERVER_NAME'}/mg;
	  	 
			if($row_setting->{'content_type'} == 1) {
				$body =~ s/<br>/\n/ig;
				$body =~ s/<(\/)?[^>]*>//g;
			}
			else{
				$body =~ s/\n/<br>/g;  
			}		
			
			if($query_attach->rows>0) {
			
				$body .= "\n\n\n";
				
				while(my $row_attach = $query_attach->fetchrow_hashref()) {
					my $name = $row_attach->{'name'};
					my $attach_file = $row_attach->{'attach'};
					my @string = split(/\r\n/, $attach_file, 76);

					if($charset ne 'utf-8') {
						Encode::from_to($name, 'utf-8', $charset);
					}
			
					if(check_kir($name, 'utf-8') eq true){
						$name = encode_str($name,$charset);
					}
		
					$body .= "--".$boundary."\n";
					$body .= "Content-Type: ".($row_attach->{'mimetype'} ne '' ? $row_attach->{'mimetype'} : 'application/octet-stream')."; name=".$name."\n";
					$body .= "Content-Transfer-Encoding: base64\n";
					$body .= "Content-Disposition: attachment; filename=".$name."\n";
					$body .= "\n";
					
					while(@string){
						$string = shift @string;
						$body .= $string;
					}					
				}
		  
				$body .= "--".$boundary."--";
	  		}	 			
		
			$query_attach->finish();
			
			my $result_send = &send_mail($email, $header, $body);
			
			if($result_send == 300){
				if($row_setting->{'re_send'} eq "no"){
					$dbh->do("INSERT INTO ".Constants::DB_READY." (`id_ready_send`,`id_user`,`id_send`) VALUES (0,".$users->{'id'}.",".$send->{'id_send'}.")");
				}
		
				my $update = $dbh->prepare("UPDATE ".Constants::DB_USERS." SET time_send = NOW() WHERE id_user=".$users->{'id'});
				$update->execute() or die("Error executing SQL query!");
		
				$mailcount = $mailcount+1;			
				$update->finish();	
			}
			elsif($result_send == 500) {
				print $ERR_CANNOT_CONNECT_TO_SERVER;
			}
			elsif($result_send == 501){
				print $ERR_AUTHORIZATION_ERROR;
			}

			if($row_setting->{'send_limit'} eq "yes" and $row_setting->{'limit_number'} == $mailcount) { 
				break; 
			}
		}
		
		if($row_setting->{'send_limit'} eq "yes" and $row_setting->{'limit_number'} == $mailcount) {
			break;
		}	
	}
	
	$query_users->finish();	
}

$query->finish();	

my $sendtime = strftime("%Y-%m-%d %H:%M:%S", localtime);
$dbh->do("INSERT INTO ".Constants::DB_LOG." (`id_log`,`count`,`time`) VALUES (0,".$mailcount.",'".$sendtime."')");

$dbh->disconnect();

print $STR_SENT.": ".$mailcount;