#!/usr/bin/perl

# Perl Newsletter v2.0.1
# (C) 2010-2014 Alexander Yanitsky
# website: http://janicky.com
# e-mail: janickiy@mail.ru
# skype: janickiy

use DBI;
use URI::Escape;
use locale;
use POSIX;
use File::Basename;
use MIME::Base64;
use Encode;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
use Net::SMTP;

use Constants;
use ConnectDB;
use GetSetting;

print "Content-type: text/html;charset=utf-8\r\n\r\n";

require 'admin/lib/_functions.pl' or die('Cannot open the file "functions.pl"!');
require 'admin/language/'.$row_setting->{'language'}.'/language.pl' or die('Cannot open the file "language.pl"!');

my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_CHAR." WHERE id_charset=".$row_setting->{'id_charset'}."");
$query->execute() or die("Error executing SQL query!");

my $row = $query->fetchrow_hashref();
	
my $charset = $row->{'charset'};

$query->finish();

my $name = trim(param("name"));
my $email = trim(param("email"));

if(param("name") eq '') { error($ERR_EMPTY_USERNAME); }
if(param("email") eq '') { error($ERR_EMPTY_EMAIL); }

$name = htmlspecialchars($name);

if(check_email($email) ne true){
	error($ERR_WRONG_EMAIL);
}

$query = $dbh->prepare("SELECT * FROM ".Constants::DB_USERS." WHERE email LIKE '$email'");
$query->execute() or die("Error executing SQL query!");

if(scalar(@_=$query->fetchrow_array) > 0){
	error($ERR_SUB_HAS_ALREADY_BEEN_MADE);
}

$query->finish();

$name = invert_comas($name);
$email = invert_comas($email);

my $ip = $ENV{'REMOTE_ADDR'};
my $token = getRandomCod();
my $time = strftime("%Y-%m-%d %H:%M:%S", localtime);

my $query = $dbh->prepare("INSERT INTO ".Constants::DB_USERS." (`id_user`,`name`,`email`,`ip`,`token`,`time`,`status`,`time_send`) VALUES (0,'".$name."','".$email."','".$ip."','".$token."','".$time."','noactive','0000-00-00 00:00:00')");
$query->execute() or die("Error executing SQL query!");

my $id = $query->{'mysql_insertid'};
		 
my $confirmlink = "http://".$ENV{'SERVER_NAME'}.root()."subscribe.pl?id=$id&token=$token";
my $unsublink = "http://".$ENV{'SERVER_NAME'}.root()."unsubscribe.pl?id=$id&key=$token";

$row_setting->{'textconfirmation'} =~ s/%NAME%/$name/g;
$row_setting->{'textconfirmation'} =~ s/%DAYS%/$row_setting->{'day'}/g;
$row_setting->{'textconfirmation'} =~ s/%CONFIRM%/$confirmlink/g;
$row_setting->{'textconfirmation'} =~ s/%UNSUB%/$unsublink/g;
$row_setting->{'textconfirmation'} =~ s/%SERVER_NAME%/$ENV{'SERVER_NAME'}/g;

if($charset ne 'utf-8') { Encode::from_to($row_setting->{'subjecttextconfirm'}, 'utf-8', $charset); } 
if($charset ne 'utf-8') { Encode::from_to($row_setting->{'textconfirmation'}, 'utf-8', $charset); }
	
if(check_kir($row_setting->{'subjecttextconfirm'}) eq true){
	$row_setting->{'subjecttextconfirm'} = encode_base64($row_setting->{'subjecttextconfirm'});
	$row_setting->{'subjecttextconfirm'} = "=?$charset?B?$row_setting->{'subjecttextconfirm'}?=";
	$row_setting->{'subjecttextconfirm'} =~ s/(\r\n)|(\n)//g;
}

my $from;
	
if($row_setting->{'show_email'} eq 'yes') { $from = "From: $ENV{'SERVER_NAME'} <$row_setting->{'email'}>"; }
else { $from = "From: $ENV{'SERVER_NAME'} <noreply\@$ENV{'SERVER_NAME'}>"; }

if($row_setting->{'newsubscribernotify'} eq 'yes'){
	my $subject = $row_setting->{'subjecttextconfirm'};
	if($charset ne 'utf-8') { Encode::from_to($subject, 'utf-8', $charset); }
	
	my $msg = "".$MSG_NOTIFICATION_NEWUSER."\nName: ".$name." \nE-mail: ".$email."\n";
	$msg =~ s/\%SITE\%/$ENV{'SERVER_NAME'}/mg;
	
	if($charset ne 'utf-8') { Encode::from_to($msg, 'utf-8', $charset); }
		
	my $smtp = Net::SMTP-> new('localhost',Timeout => $row_setting->{'smtp_timeout'}) or die "Couldn't open connection: $!" if (!defined $smtp );
	$smtp-> mail($row_setting->{'email'}."\n");
	$smtp-> to($row_setting->{'email'});
	$smtp-> data();
	$smtp-> datasend("MIME-Version: 1.0\n");
	$smtp-> datasend("To: ".$row_setting->{'email'}."\n");
	$smtp-> datasend("From: ".$row_setting->{'email'}."\n");
	$smtp-> datasend("Subject: ".$subject."\n");
	$smtp-> datasend("Content-type: text/plain; charset=".$charset."\n");
	$smtp-> datasend("Content-Transfer-Encoding: 8bit\n");
	$smtp-> datasend("\n\n");
	$smtp-> datasend("".$msg."\n");
	$smtp-> dataend();
	$smtp-> quit;
}

my $smtp = Net::SMTP-> new('localhost',Timeout => $row_setting->{'smtp_timeout'}) or die "Couldn't open connection: $!" if (!defined $smtp );
$smtp-> mail($row_setting->{'email'}."\n");
$smtp-> to($email);
$smtp-> data();
$smtp-> datasend("MIME-Version: 1.0\n");
$smtp-> datasend("To: ".$email."\n");
$smtp-> datasend($from."\n");
$smtp-> datasend("Subject: ".$row_setting->{'subjecttextconfirm'}."\n");
$smtp-> datasend("Content-type: text/plain; charset=".$charset."\n");
$smtp-> datasend("Content-Transfer-Encoding: 8bit\n");
$smtp-> datasend("\n\n");
$smtp-> datasend("".$row_setting->{'textconfirmation'}."\n");
$smtp-> dataend();
$smtp-> quit;
	
print "<!DOCTYPE html>\n";
print "<html>\n";
print "<head>\n";
print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n";
print "<title>".$SENDMAIL_TITLE_PAGE."</title>\n";
print "</head>\n";
print "<body>\n";
print "<center><br>".$MSG_SUBSCRIPTION."<br><br>\n";
print "<a href=javascript:history.go(-1);>".$STR_RETURN_BACK."</a><br>\n";
print "<a href=http://$ENV{'SERVER_NAME'}>".$STR_GO_HOME."</a><br>\n";
print "</center>\n";
print "</body>\n";
print "</html>";
	 
$dbh->disconnect();
	 
exit;