CREATE TABLE `sm_attach` (
  `id_attachment` int(6) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `attach` mediumblob NOT NULL,
  `mimetype` varchar(200) NOT NULL,
  `id_send` int(6) NOT NULL,
  PRIMARY KEY  (`id_attachment`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `sm_aut` (
  `passw` varchar(32) NOT NULL,
  `id_session` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sm_aut` (`passw`, `id_session`) VALUES ('b59c67bf196a4758191e42f76670ceba', '');

CREATE TABLE `sm_cat` (
  `id_cat` int(6) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_cat`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `sm_cat` (`id_cat`, `name`) VALUES
(1, 'Category 1'),
(2, 'Category 2'),
(3, 'Category 3');

CREATE TABLE `sm_charset` (
  `id_charset` int(7) NOT NULL auto_increment,
  `charset` varchar(32) NOT NULL,
  PRIMARY KEY  (`id_charset`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `sm_charset` (`id_charset`, `charset`) VALUES
(1, 'utf-8'),
(2, 'iso-8859-1'),
(3, 'iso-8859-2'),
(4, 'iso-8859-3'),
(5, 'iso-8859-4'),
(6, 'iso-8859-5'),
(7, 'iso-8859-6'),
(8, 'iso-8859-8'),
(9, 'iso-8859-7'),
(10, 'iso-8859-9'),
(11, 'iso-8859-10'),
(12, 'iso-8859-13'),
(13, 'iso-8859-14'),
(14, 'iso-8859-15'),
(15, 'iso-8859-16'),
(16, 'windows-1250'),
(17, 'windows-1251'),
(18, 'windows-1252'),
(19, 'windows-1253'),
(20, 'windows-1254'),
(21, 'windows-1255'),
(22, 'windows-1256'),
(23, 'windows-1257'),
(24, 'windows-1258'),
(25, 'gb2312'),
(26, 'big5'),
(27, 'iso-2022-jp'),
(28, 'ks_c_5601-1987'),
(29, 'euc-kr'),
(30, 'windows-874'),
(31, 'koi8-r'),
(32, 'koi8-u');

CREATE TABLE `sm_log` (
  `id_log` int(7) NOT NULL auto_increment,
  `count` int(7) NOT NULL,
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_log`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `sm_ready_send` (
  `id_ready_send` int(10) NOT NULL auto_increment,
  `id_user` int(7) NOT NULL,
  `id_send` int(7) NOT NULL,
  PRIMARY KEY  (`id_ready_send`),
  KEY `id_user` (`id_user`),
  KEY `id_send` (`id_send`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `sm_send` (
  `id_send` int(7) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `message` mediumtext NOT NULL,
  `prior` enum('1','2','3') NOT NULL default '1',
  `pos` int(6) NOT NULL,
  `id_cat` int(6) NOT NULL,
  `active` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`id_send`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `sm_settings` (
  `number_pos` tinyint(4) NOT NULL default '0',
  `language` enum('en','ru') NOT NULL default 'ru',
  `number_pos_users` tinyint(4) NOT NULL default '0',
  `organization` varchar(200) NOT NULL,
  `email` varchar(200) NOT NULL,
  `show_email` enum('yes','no') NOT NULL default 'yes',
  `send_server` tinyint(1) NOT NULL default '1',
  `content_type` tinyint(1) NOT NULL default '1',
  `smtp_host` varchar(200) NOT NULL,
  `smtp_username` varchar(200) NOT NULL,
  `smtp_password` varchar(200) NOT NULL,
  `smtp_port` int(6) NOT NULL,
  `smtp_ssl` enum('yes','no') NOT NULL,
  `smtp_timeout` int(6) NOT NULL,
  `id_charset` tinyint(4) NOT NULL default '0',
  `number_days` tinyint(4) NOT NULL default '1',
  `limit_send` enum('yes','no') NOT NULL default 'no',
  `number_limit` int(6) NOT NULL default '100',
  `re_send` enum('yes','no') NOT NULL default 'no',
  `delete_subs` enum('yes','no') NOT NULL default 'yes',
  `reply` enum('yes','no') NOT NULL default 'no',
  `unsubscribe` enum('yes','no') NOT NULL,
  `subjecttextconfirm` varchar(255) NOT NULL,
  `textconfirmation` text NOT NULL,
  `unsublink` text NOT NULL,
  `newsubscribernotify` enum('yes','no') NOT NULL default 'yes',
  `type_interval` enum('m','h','d','no') NOT NULL,
  `number_interval` int(6) NOT NULL,
  `show_list_id` enum('yes','no') NOT NULL default 'no',
  `precedence` enum('no','bulk','junk','list') NOT NULL default 'no'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sm_settings` (`number_pos`, `language`, `number_pos_users`, `organization`, `email`, `show_email`, `send_server`, `content_type`, `smtp_host`, `smtp_username`, `smtp_password`, `smtp_port`, `smtp_ssl`, `smtp_timeout`, `id_charset`, `number_days`, `limit_send`, `number_limit`, `re_send`, `delete_subs`, `reply`, `unsubscribe`, `subjecttextconfirm`, `textconfirmation`, `unsublink`, `newsubscribernotify`, `type_interval`, `number_interval`, `show_list_id`, `precedence`) VALUES
(5, 'ru', 40, '', 'info@janicky.com', 'yes', 1, 1, 'smtp.gmail.com', '', '', 25, 'no', 5, 1, 7, 'yes', 300, 'yes', 'yes', 'no', 'yes', 'Подписка на рассылку', 'Здравствуйте, %NAME%\r\n\r\nПолучение &quot; рассылки возможно после завершения этапа активации подписки. У Вас %DAYS% дн. чтобы активировать подписку. Для этого следует перейти по следующей ссылке: %CONFIRM%\r\nЕсли Вы не производили подписку на данный email, просто проигнорируйте данное письмо или перейдите по ссылке: %UNSUB%\r\nС уважением, администратор сайта %SERVER_NAME%', 'Отписаться от рассылки: <a href=%UNSUB%>%UNSUB%</a>', 'no', 'no', 1, 'yes', 'bulk');

CREATE TABLE `sm_subscription` (
  `id_sub` int(7) NOT NULL auto_increment,
  `id_user` int(7) NOT NULL,
  `id_cat` int(5) NOT NULL,
  PRIMARY KEY  (`id_sub`),
  KEY `id_cat` (`id_cat`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `sm_users` (
  `id_user` int(6) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `token` varchar(50) NOT NULL,
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` enum('active','noactive') NOT NULL default 'noactive',
  `time_send` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;