<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\SendEmailHelper;
use App\Helpers\StringHelper;
use App\Http\Requests\Admin\Subscribers\ImportRequest;
use App\Models\Subscribers;
use App\Models\Subscriptions;
use \Generator;


use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

use Illuminate\Support\Facades\URL;


class TestController extends Controller
{
    public function index()
    {
        $mail = new PHPMailer(true);
        $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
        $mail->isSMTP();                                            //Send using SMTP
        $mail->Host       = 'smtp.yandex.ru';                     //Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
        $mail->Username   = 'yanack';                     //SMTP username
        $mail->Password   = 'Depeche81!';                               //SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
        $mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

        //Recipients
        $mail->setFrom('yanack@yandex.ru', 'Mailer');
    //    $mail->addAddress('yanack@yandex.ru', 'Joe User');     //Add a recipient

        $mail->addAddress('janickiy@mail.ru');


        //Content
        $mail->isHTML(true);                                  //Set email format to HTML
        $mail->Subject = 'Here is the subject';
        $mail->Body    = 'This is the HTML message body <b>in bold!</b>';
        $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

        $mail->send();
    }

    public function import(ImportRequest $request)
    {
        self::getData($request);
    }

    private static function getData($f)
    {
        $iterator = static function ($data): Generator {
            yield from new \ArrayIterator($data);
        };

        $processed_data = static function (Worksheet $data) use ($iterator): ?array {
            $key_lists = [];
            $init_data = [];
            foreach ($iterator($data->toArray()) as $item) {
                if (empty($key_lists)) {
                    if (is_null($item[0])) break;

                    $item = array_map(static fn($_item) => trim((string)$_item), $item);
                    $key_lists = $item;
                } else {
                    if (empty($key_lists)) break;

                    $item = array_map(static fn($_item) => trim((string)$_item), $item);
                    $init_data[] = array_combine($key_lists, $item);
                }
            }

            return (empty($init_data))
                ? null
                : $init_data;
        };

        $extension = strtolower($f->file('import')->getClientOriginalExtension());

        $open_file = static function (string $file) use ($extension): ?Spreadsheet {

            switch ($extension) {
                case 'xlsx':
                    $inputFileType = 'Xlsx';
                    break;
                case 'xls':
                    $inputFileType = 'Xls';
                    break;
                case 'csv':
                    $inputFileType = 'Csv';
                    break;
                case 'ods':
                    $inputFileType = 'Ods';
                    break;
            }

            $reader = IOFactory::createReader($inputFileType);
            $reader->setReadDataOnly(false);

            return $reader->load($file);
        };

        $processed = static function (Spreadsheet $spreadsheet) use ($iterator, $processed_data): int {
            $count = 0;
            $sheetNames = [];
            foreach ($iterator($spreadsheet->getSheetNames()) ?? [] as $item_name) {
                $sheetNames[] = $item_name;
            }

            $sheetCount = $spreadsheet->getSheetCount();

            $i = 0;
            while ($i < $sheetCount) {
                $options = $processed_data($spreadsheet->getSheet($i));

                foreach ($options ?? [] as $option) {
                    $keys = array_keys($option);
                    $email = $option[$keys[0]];
                    $name = $option[$keys[1]];

                    if (StringHelper::isEmail($email)) {
                        $subscriber = Subscribers::where('email', 'like', $email)->first();

                        if ($subscriber) {
                            $subscriber->remove();
                            foreach ($f->categoryId ?? [] as $categoryId) {
                                if (is_numeric($categoryId)) {
                                    Subscriptions::create([
                                        'subscriber_id' => $subscriber->id,
                                        'category_id' => $categoryId,
                                    ]);
                                }
                            }
                        } else {
                            $insertId = Subscribers::create([
                                'name' => $name,
                                'email' => $email,
                                'active' => 1,
                                'timeSent' => date('Y-m-d H:i:s'),
                                'token' => StringHelper::token()
                            ])->id;

                            foreach ($f->categoryId ?? [] as $category) {
                                if (is_numeric($category)) {
                                    Subscriptions::create([
                                        'subscriber_id' => $insertId,
                                        'category_id' => $category,
                                    ]);
                                }
                            }

                            $count++;
                        }
                    }
                }

                $i++;
            }

            return $count;
        };



       // dd($extension);

        $worksheetData = $open_file($f->file('import'));
        $count = $processed($worksheetData);
        echo $count;

        exit;

       // var_dump($processed);
    }
}
