#!/usr/bin/perl

# Perl Guestbook v1.1 
# 2008-2011 (C) Alexander Yanitsky 
# web site: janicky.com                          
# e-mail: janickiy@mail.ru
# ICQ: 305-972                       

use DBI;
use URI::Escape;
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
use Constants;
  
print "Content-type: text/html; charset=".Constants::CHARSET."\r\n\r\n";

use ConnectDB;
use GetSetting;

#  
$title = '  - Perl Guestbook';
$description = '';
$keywords = '';
  
#  ip
if($ENV{'HTTP_X_FORWARDED_FOR'}) 
{
   $ip = $ENV{'HTTP_X_FORWARDED_FOR'};
} 
else 
{
   $ip = $ENV{'REMOTE_ADDR'};
}

#   
require "lib/_function.pl" or die('"_function.pl"');

# 
require "lib/_top.pl" or die('"_top.pl"');

my %GET;
my @pairs = split(/&/, $ENV{ "QUERY_STRING" });

foreach (@pairs)
{
   my ($name, $value) = split(/=/, $_);
   $GET{$name} = $value;
   $value = uri_unescape($value);
}

#   
my $page = int($GET{'page'});
if($page == 0) { $page = 1; }
if($row_setting->{number_post} == 0) { $row_setting->{number_post} = 10; }
$begin = ($page - 1)*$row_setting->{number_post};

print <<HTML1;
<table width="80%" cellpadding="0" cellspacing="0" border="0">
<tr>
  <td><center>
      <br>
      <table border="0">
        <tr>
          <td><img src="http://$ENV{ "SERVER_NAME" }/images/notepad.gif" width="16" height="16" border="0"></td>
          <td><a title=" " href="add.pl"> </a></td>
        </tr>
      </table>
    </center>
    <br>
HTML1

#   
my $query = $dbh->prepare("SELECT * FROM ".Constants::DB_MSG." WHERE hide = 'show' ORDER BY time DESC LIMIT $begin, ".$row_setting->{number_post}."");
$query->execute() or die("   SQL !");
 
while($row = $query->fetchrow_hashref())
{ 
   my $name   = $row->{name};
   my $msg    = $row->{msg};
   my $city   = $row->{city};
   my $email  = $row->{email};
   my $url    = $row->{url};
   my $ip     = $row->{ip};
   my $answer = $row->{answer};
   my $time   = $row->{time};
  
   $name   =~ s/^\s+|\s+$//g;
   $msg    =~ s/^\s+|\s+$//g;
   $city   =~ s/^\s+|\s+$//g;
   $email  =~ s/^\s+|\s+$//g;
   $url    =~ s/^\s+|\s+$//g;
   $ip     =~ s/^\s+|\s+$//g;
   $answer =~ s/^\s+|\s+$//g;
   $time   =~ s/^\s+|\s+$//g;
  
   if($row_setting->{smile} eq 'yes')
   {
      $msg =~ s/\[:\)\)\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_biggrin.gif">/g;
      $msg =~ s/\[:~\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_confused.gif">/g;
      $msg =~ s/\[:\)\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_cool.gif">/g;
      $msg =~ s/\[:\(\|\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_mad.gif">/g;
      $msg =~ s/\[:\|\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_eek.gif">/g;
      $msg =~ s/\[:\(\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_frown.gif">/g;
      $msg =~ s/\[:\(\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_frown.gif">/g;
      $msg =~ s/\[:\|\)\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_smile.gif">/g;
      $msg =~ s/\[:\/\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_wink.gif">/g;
      $msg =~ s/\[:\(\)\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_razz.gif">/g;
      $msg =~ s/\[:\/~\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_blush.gif">/g;
      $msg =~ s/\[:\/\(\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_cray.gif">/g;
      $msg =~ s/\[:\)\(\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_dance.gif">/g;
      $msg =~ s/\[:\|_\|\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_drinks.gif">/g;
      $msg =~ s/\[:\?\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_fool.gif">/g;
      $msg =~ s/\[:\)\|\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_good.gif">/g;
      $msg =~ s/\[:\@\@\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_kiss_mini.gif">/g;
      $msg =~ s/\[:\)-\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_man_in_love.gif">/g;
      $msg =~ s/\[:-\@\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_rolleyes.gif">/g;
      $msg =~ s/\[:\|\|\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_scratch.gif">/g;
      $msg =~ s/\[:\@\|\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_shok.gif">/g;
      $msg =~ s/\[:\@\(\|\)\]/<IMG border=0 src="http:\/\/$ENV{ "SERVER_NAME" }\/smile\/icon_shout.gif">/g;
   }
   else
   {
      $msg =~ s/\[:\)\)\]//g;
      $msg =~ s/\[:~\]//g;
      $msg =~ s/\[:\)\]//g;
      $msg =~ s/\[:\(\|\]//g;
      $msg =~ s/\[:\|\]//g;
      $msg =~ s/\[:\(\]//g;
      $msg =~ s/\[:\(\]//g;
      $msg =~ s/\[:\|\)\]//g;
      $msg =~ s/\[:\/\]//g;
      $msg =~ s/\[:\(\)\]//g;
      $msg =~ s/\[:\/~\]//g;
      $msg =~ s/\[:\/\(\]//g;
      $msg =~ s/\[:\)\(\]//g;
      $msg =~ s/\[:\|_\|\]//g;
      $msg =~ s/\[:\?\]//g;
      $msg =~ s/\[:\)\|\]//g;
      $msg =~ s/\[:\@\@\]//g;
      $msg =~ s/\[:\)-\]//g;
      $msg =~ s/\[:-\@\]//g;
      $msg =~ s/\[:\|\|\]//g;
      $msg =~ s/\[:\@\|\]//g;
      $msg =~ s/\[:\@\(\|\)\]//g;
   }

print <<HTML2;
<table class="cattab" border="0" width="100%">
<tr>
  <td class="menu"><table border="0" width="100%">
    <tr>
      <td width="50%"><p><b>$name</b><br>
HTML2

   if($city ne '') { print ": $city <br>"; }
   if($email ne '') { print "E-mail: $email <br>"; }
   if($url ne '') { print ": <a class=link href='$url'>$url</a>"; }

print <<HTML3; 
</td>

<td width="50%"><p align="right"><i>: $time</i></td>
</tr>
</table>
</td>
</tr>
<tr>
  <td height="36"><p> 
HTML3
   
   print "$msg";

   if($answer ne '' && $answer ne '-') 
   {
      print "<font color=\#FF0000><p>: $answer</p></font>";
   } 

   print '</p></td></tr></table>';

}

print <<HTML4; 
<center>
  <br>
  <table border="0">
    <tr>
      <td><img src="http://$ENV{ "SERVER_NAME" }/images/notepad.gif" width="16" height="16" border="0"></td>
      <td><a title=" " href="add.pl"> </a></td>
    </tr>
  </table>
</center>
HTML4

#  
$query->finish();

#   
my $query = $dbh->prepare("SELECT count(*) FROM ".Constants::DB_MSG." WHERE hide = 'show'");
$query->execute() or die("   SQL !");
my $count = $query->fetchrow_arrayref()->[0];
  
#  
$query->finish();
  
my $number = int(($count - 1) / $row_setting->{number_post}) + 1;

if($page != 1)
{  
   $pervpage = '<a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page=1>&lt;&lt;</a> 
                <a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.($page - 1).'>&lt;</a> '; 
}

if($page != $number)
{ 
   $nextpage = ' <a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 1).'>&gt;</a> 
                <a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.$number.'>&gt;&gt;</a>'; 
}

if(($page - 2) > 0) { $page2left = '<a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.($page - 2).'>...'.($page - 2).'</a> | '; }
if(($page - 1) > 0) { $page1left = '<a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.($page - 1).'>'.($page - 1).'</a> | '; }
if(($page + 2) <= $number) { $page2right = ' | <a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 2).'>'.($page + 2).'...</a>'; }
if(($page + 1) <= $number) { $page1right = ' | <a href=http://'.$ENV{ "SERVER_NAME" }.$ENV{ "SCRIPT_NAME" }.'?page='.($page + 1).'>'.($page + 1).'</a>'; }

print "<p> :&nbsp;[$count]&nbsp;&nbsp;&nbsp;:  ";
print $pervpage.$page2left.$page1left.'<b>'.$page.'</b>'.$page1right.$page2right.$nextpage.'</p>';

# 
require 'lib/_bottom.pl' or die('    "_bottom.pl"');

#    
$dbh->disconnect();
